/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.commonservices.internal.trace;

import com.ibm.mq.commonservices.Common;
import com.ibm.mq.commonservices.internal.trace.AMQLogEntry;
import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.CommonServices;
import com.ibm.mq.commonservices.internal.utils.RASProperties;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.SimpleDateFormat;
import java.util.Enumeration;
import java.util.Hashtable;

public class AMQLogger
extends Thread {
    public static final String SCCSID = "@(#) eclipse/com.ibm.mq.commonservices/src/com/ibm/mq/commonservices/internal/trace/AMQLogger.java, javagui, p701, p701-112-140304  1.10.2.2 10/02/26 17:32:41";
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005, 2009";
    public static final String MY_NAME = "WebSphere MQ AMQ logger";
    private static final String EXPLANATION = "EXPLANATION:";
    private static final String ACTION = "ACTION:";
    private static final String MSGKEY_EXPLANATION = ".XPL";
    private static final String MSGKEY_ACTION = ".URESP";
    private RASProperties properties = null;
    private OutputStreamWriter fileStreamWriter = null;
    private PrintWriter consoleWriter = null;
    private static SimpleDateFormat dateFormat = new SimpleDateFormat("dd/MM/yy HH:mm:ss");
    private static boolean closing = false;
    private static int refreshInterval = 300000;
    private Hashtable workItems = new Hashtable();
    private int itemCounter = 0;
    private static AMQLogger amqLog = null;
    private FileOutputStream fileOutputStream = null;

    public AMQLogger(Trace t, RASProperties props) {
        String fid = "AMQLogger.constructor";
        t.entry(64, "AMQLogger.constructor");
        this.properties = props;
        this.createOutputStreams(t);
        amqLog = this;
        if (Trace.isTracing) {
            t.data(64, "AMQLogger.constructor", 300, "New AMQ logger created");
        }
        this.setDaemon(true);
        this.setName(MY_NAME);
        this.start();
        t.exit(64, "AMQLogger.constructor");
    }

    private void createOutputStreams(final Trace t) {
        block8: {
            block7: {
                String fid = "AMQLogger.createOutputStreams";
                t.entry(64, "AMQLogger.createOutputStreams");
                if (this.properties.isTracingToFile() && this.properties.isErrorsFilenameValid() && this.properties.getJavaLogFile() != null) {
                    try {
                        this.fileOutputStream = (FileOutputStream)AccessController.doPrivileged(new PrivilegedAction(){

                            public Object run() {
                                block4: {
                                    try {
                                        return new FileOutputStream(AMQLogger.this.properties.getJavaLogFile(), true);
                                    }
                                    catch (FileNotFoundException fnfe) {
                                        if (Trace.isTracing) {
                                            t.data(64, "AMQLogger.createOutputStreams", 900, "FileNotFoundException for " + AMQLogger.this.properties.getJavaLogFile());
                                        }
                                    }
                                    catch (AccessControlException ace) {
                                        if (!Trace.isTracing) break block4;
                                        t.data(64, "AMQLogger.createOutputStreams", 900, "AccessControlException for " + AMQLogger.this.properties.getJavaLogFile());
                                    }
                                }
                                return null;
                            }
                        });
                        if (this.fileOutputStream != null) {
                            this.fileStreamWriter = new OutputStreamWriter((OutputStream)this.fileOutputStream, "UTF8");
                        }
                    }
                    catch (UnsupportedEncodingException uee) {
                        if (!Trace.isTracing) break block7;
                        t.data(64, "AMQLogger.createOutputStreams", 900, "UnsupportedEncodingException for UTF8");
                    }
                }
            }
            if (this.properties.isTracingToConsole()) {
                try {
                    this.consoleWriter = new PrintWriter(new OutputStreamWriter((OutputStream)System.err, "UTF8"));
                }
                catch (UnsupportedEncodingException e1) {
                    if (!Trace.isTracing) break block8;
                    t.data(64, "AMQLogger.createOutputStreams", 900, "UnsupportedEncodingException for UTF8");
                }
            }
        }
        t.exit(64, "AMQLogger.createOutputStreams");
    }

    public synchronized void addLogEntry(Trace t, int rc, int insert1, int insert2, String insert3, String insert4, String insert5, String fileName, int lineNum, int options) {
        String fid = "AMQLogger.addLogEntry";
        t.entry(64, "AMQLogger.addLogEntry");
        AMQLogEntry workItem = new AMQLogEntry(t, insert3, insert4, insert5);
        this.workItems.put(new Integer(this.itemCounter++), workItem);
        this.wakeup(t);
        t.exit(64, "AMQLogger.addLogEntry");
    }

    private void generateEntry(Trace t, AMQLogEntry logEntry) {
        String fid = "AMQLogger.generateEntry";
        t.entry(64, "AMQLogger.generateEntry");
        if (this.fileStreamWriter != null || this.consoleWriter != null) {
            this.write(t, dateFormat.format(logEntry.getLogEntryTimestamp()) + " Process(" + this.properties.getDiagId() + ") User(" + logEntry.getUserId() + ") Program(" + logEntry.getProgram() + ")");
            String text = CommonServices.getSystemMessage(logEntry.getMessageId());
            this.write(t, logEntry.getMessageId() + ": " + text);
            String explanation = CommonServices.getSystemMessage(logEntry.getMessageId() + MSGKEY_EXPLANATION);
            this.write(t, EXPLANATION);
            this.write(t, explanation);
            String action = CommonServices.getSystemMessage(logEntry.getMessageId() + MSGKEY_ACTION);
            this.write(t, ACTION);
            this.write(t, action);
            this.write(t, "------------------------------------------------------------------------");
            if (this.fileStreamWriter != null) {
                try {
                    this.fileStreamWriter.flush();
                    this.fileStreamWriter.close();
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            if (this.consoleWriter != null) {
                this.consoleWriter.flush();
            }
        }
        t.exit(64, "AMQLogger.generateEntry");
    }

    private void write(Trace t, String data) {
        String fid = "AMQLogger.write";
        t.entry(64, "AMQLogger.write");
        this.writeToConsole(t, data);
        this.writeToFile(t, data);
        t.exit(64, "AMQLogger.write");
    }

    private void writeToConsole(Trace t, String data) {
        String fid = "AMQLogger.writeToConsole";
        t.entry(64, "AMQLogger.writeToConsole");
        if (this.properties.isTracingToConsole() && this.consoleWriter != null) {
            this.consoleWriter.println(data);
        }
        t.exit(64, "AMQLogger.writeToConsole");
    }

    private void writeToFile(Trace t, String data) {
        block3: {
            String fid = "AMQLogger.writeToFile";
            t.entry(64, "AMQLogger.writeToFile");
            try {
                if (this.properties.isTracingToFile() && this.fileStreamWriter != null) {
                    this.fileStreamWriter.write(data + Common.LINE_SEPARATOR);
                }
            }
            catch (IOException ioe) {
                if (!Trace.isTracing) break block3;
                t.data(64, "AMQLogger.writeToFile", 900, "Error writing to " + this.properties.getJavaLogFilename() + Common.LINE_SEPARATOR + ioe);
            }
        }
        t.exit(64, "AMQLogger.writeToFile");
    }

    public void close(Trace t) {
        block3: {
            String fid = "AMQLogger.close";
            t.entry(64, "AMQLogger.close");
            if (this.fileStreamWriter != null) {
                try {
                    this.fileStreamWriter.flush();
                    this.fileStreamWriter.close();
                }
                catch (IOException ioe) {
                    if (!Trace.isTracing) break block3;
                    t.data(64, "AMQLogger.close", 900, "Error closing to " + this.properties.getJavaLogFilename() + Common.LINE_SEPARATOR + ioe);
                }
            }
        }
        closing = true;
        amqLog.interrupt();
        t.exit(64, "AMQLogger.close");
    }

    public void wakeup(Trace t) {
        String fid = "AMQLogger.wakeup";
        t.entry(64, "AMQLogger.wakeup");
        amqLog.interrupt();
        t.exit(64, "AMQLogger.wakeup");
    }

    public void run() {
        String fid = "AMQLogger.run";
        Trace t = Trace.getDefault();
        t.entry(64, "AMQLogger.run");
        while (!closing) {
            block5: {
                try {
                    Thread.sleep(refreshInterval);
                }
                catch (InterruptedException ie) {
                    if (!Trace.isTracing) break block5;
                    t.data(64, "AMQLogger.run", 900, "AMQ logger interrupted");
                }
            }
            if (Trace.isTracing) {
                t.data(64, "AMQLogger.run", 900, "AMQ logger checking for work");
            }
            this.processWork(t);
            if (!closing) continue;
        }
        if (Trace.isTracing) {
            t.data(64, "AMQLogger.run", 300, "AMQ logger ended");
        }
        t.exit(64, "AMQLogger.run");
    }

    private void processWork(Trace t) {
        String fid = "AMQLogger.processWork";
        FileLock lock = null;
        t.entry(64, "AMQLogger.processWork");
        if (Trace.isTracing) {
            t.data(64, "AMQLogger.processWork", 300, "AMQ logger processing " + this.workItems.size() + " log entries");
        }
        if (this.properties.isTracingToFile() && this.fileStreamWriter != null) {
            lock = this.getFileLock(t);
        }
        Enumeration en = this.workItems.keys();
        while (en.hasMoreElements()) {
            Integer key = (Integer)en.nextElement();
            AMQLogEntry logEntry = (AMQLogEntry)this.workItems.get(key);
            if (Trace.isTracing) {
                t.data(64, "AMQLogger.processWork", 900, "AMQ logger creating log entry " + key);
            }
            this.generateEntry(t, logEntry);
            this.workItems.remove(key);
        }
        if (this.properties.isTracingToFile() && this.fileStreamWriter != null) {
            this.releaseFileLock(t, lock);
        }
        t.exit(64, "AMQLogger.processWork");
    }

    private FileLock getFileLock(Trace t) {
        FileLock lock;
        block3: {
            String fid = "AMQLogger.getFileLock";
            lock = null;
            FileChannel channel = null;
            t.entry(64, "AMQLogger.getFileLock");
            try {
                channel = this.fileOutputStream.getChannel();
                lock = channel.tryLock();
                if (Trace.isTracing) {
                    t.data(64, "AMQLogger.getFileLock", 300, "Lock obtained for " + this.properties.getJavaLogFilename());
                }
            }
            catch (IOException ioe) {
                if (!Trace.isTracing) break block3;
                t.data(64, "AMQLogger.getFileLock", 900, "Error getting lock for " + this.properties.getJavaLogFilename() + Common.LINE_SEPARATOR + ioe);
            }
        }
        t.exit(64, "AMQLogger.getFileLock");
        return lock;
    }

    private void releaseFileLock(Trace t, FileLock lock) {
        block4: {
            String fid = "AMQLogger.releaseFileLock";
            t.entry(64, "AMQLogger.releaseFileLock");
            try {
                if (lock != null) {
                    lock.release();
                }
                if (Trace.isTracing) {
                    t.data(64, "AMQLogger.releaseFileLock", 300, "Lock released for " + this.properties.getJavaLogFilename());
                }
            }
            catch (IOException ioe) {
                if (!Trace.isTracing) break block4;
                t.data(64, "AMQLogger.releaseFileLock", 900, "Error releasing lock for " + this.properties.getJavaLogFilename() + Common.LINE_SEPARATOR + ioe);
            }
        }
        t.exit(64, "AMQLogger.releaseFileLock");
    }
}

