/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.commonservices.internal.monitor;

import com.ibm.mq.commonservices.internal.monitor.ITraceMonitorListener;
import com.ibm.mq.commonservices.internal.trace.Trace;
import java.util.ArrayList;

public class TraceMonitor
extends Thread {
    public static final String SCCSID = "@(#) eclipse/com.ibm.mq.commonservices/src/com/ibm/mq/commonservices/internal/monitor/TraceMonitor.java, javagui, p701, p701-112-140304  1.7.1.1 09/08/17 00:39:07";
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005, 2009";
    public static final String MY_NAME = "WebSphere MQ Trace Monitor";
    private static boolean closing = false;
    private static int refreshInterval = 10;
    private static TraceMonitor traceMonitor = null;
    private static ArrayList listeners = new ArrayList();

    public TraceMonitor(Trace t, int ri) {
        String fid = "TraceMonitor.constructor";
        t.entry(64, "TraceMonitor.constructor");
        if (Trace.isTracing) {
            t.data(64, "TraceMonitor.constructor", 300, "WebSphere MQ Trace Monitor created");
        }
        traceMonitor = this;
        refreshInterval = ri;
        this.setDaemon(true);
        this.setName(MY_NAME);
        this.start();
        t.exit(64, "TraceMonitor.constructor");
    }

    public void run() {
        String fid = "TraceMonitor.run";
        boolean last = Trace.queryWMQTrace();
        Trace t = Trace.getDefault();
        t.entry(64, "TraceMonitor.run");
        while (!closing) {
            block6: {
                try {
                    if (Trace.isTracing) {
                        t.data(64, "TraceMonitor.run", 300, "WebSphere MQ Trace Monitor sleeping for " + refreshInterval + " seconds");
                    }
                    Thread.sleep(refreshInterval * 1000);
                }
                catch (InterruptedException ie) {
                    if (!Trace.isTracing) break block6;
                    t.data(64, "TraceMonitor.run", 300, "WebSphere MQ Trace Monitor interrupted");
                }
            }
            if (Trace.isTracing) {
                t.data(64, "TraceMonitor.run", 300, "WebSphere MQ Trace Monitor checking status");
            }
            boolean current = Trace.queryWMQTrace();
            if (closing) break;
            this.notifyListeners(last, current);
            last = current;
        }
        if (Trace.isTracing) {
            t.data(64, "TraceMonitor.run", 300, "WebSphere MQ Trace Monitor ended");
        }
        t.exit(64, "TraceMonitor.run");
    }

    public static int getRefreshInterval() {
        return refreshInterval;
    }

    public static void setRefreshInterval(int i) {
        refreshInterval = i;
        traceMonitor.interrupt();
    }

    public void close(Trace t) {
        String fid = "TraceMonitor.close";
        t.entry(64, "TraceMonitor.close");
        closing = true;
        traceMonitor.interrupt();
        t.exit(64, "TraceMonitor.close");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListeners(boolean last, boolean current) {
        ArrayList arrayList = listeners;
        synchronized (arrayList) {
            if (listeners.size() > 0 && last != current) {
                for (int i = 0; i < listeners.size(); ++i) {
                    ITraceMonitorListener listener = (ITraceMonitorListener)listeners.get(i);
                    if (current && !last) {
                        listener.enabled();
                        continue;
                    }
                    if (current || !last) continue;
                    listener.disabled();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addListener(ITraceMonitorListener tl) {
        ArrayList arrayList = listeners;
        synchronized (arrayList) {
            listeners.add(tl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeListener(ITraceMonitorListener tl) {
        ArrayList arrayList = listeners;
        synchronized (arrayList) {
            listeners.remove(tl);
        }
    }
}

