/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.commonservices.internal.console;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.CommonServices;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.Locale;

public class ConsoleInputStream {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005, 2009";
    public static final String SCCSID = "@(#) eclipse/com.ibm.mq.commonservices/src/com/ibm/mq/commonservices/internal/console/ConsoleInputStream.java, javagui, p701, p701-112-140304  1.2.2.1 09/08/16 12:04:00";
    private InputStreamReader inputStreamReader = null;

    public ConsoleInputStream(Trace t, InputStream is) {
        String fid = "ConsoleInputStream.ConsoleInputStream";
        t.entry(64, "ConsoleInputStream.ConsoleInputStream");
        String language = Locale.getDefault().getLanguage();
        if (CommonServices.PLATFORM_ID == 1 && (language.equalsIgnoreCase("fr") || language.equalsIgnoreCase("pt") || language.equalsIgnoreCase("de") || language.equalsIgnoreCase("es"))) {
            try {
                this.inputStreamReader = new InputStreamReader(is, "Cp850");
            }
            catch (UnsupportedEncodingException uee) {
                this.inputStreamReader = new InputStreamReader(is);
            }
        } else if (CommonServices.PLATFORM_ID == 1 && language.equalsIgnoreCase("ru")) {
            try {
                this.inputStreamReader = new InputStreamReader(is, "Cp866");
            }
            catch (UnsupportedEncodingException uee) {
                this.inputStreamReader = new InputStreamReader(is);
            }
        } else if (CommonServices.PLATFORM_ID == 1 && (language.equalsIgnoreCase("hu") || language.equalsIgnoreCase("pl") || language.equalsIgnoreCase("cs"))) {
            try {
                this.inputStreamReader = new InputStreamReader(is, "Cp852");
            }
            catch (UnsupportedEncodingException uee) {
                this.inputStreamReader = new InputStreamReader(is);
            }
        } else {
            this.inputStreamReader = new InputStreamReader(is);
        }
        if (Trace.isTracing) {
            t.data(64, "ConsoleInputStream.ConsoleInputStream", 300, "Using character set " + this.inputStreamReader.getEncoding());
        }
        t.exit(64, "ConsoleInputStream.ConsoleInputStream");
    }

    public InputStreamReader getInputStreamReader() {
        return this.inputStreamReader;
    }
}

