/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.commonservices.internal.console;

import com.ibm.mq.commonservices.internal.trace.Trace;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class ConsoleCommandParser {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005, 2009";
    public static final String SCCSID = "@(#) eclipse/com.ibm.mq.commonservices/src/com/ibm/mq/commonservices/internal/console/ConsoleCommandParser.java, javagui, p701, p701-112-140304  1.1.1.1 09/08/16 14:45:14";
    private static final String PARAMETER_DELIMETER = " ";
    private static final String STRING_DELIMETER = "\"";
    private String stringDelimeter = "\"";
    private String[] parsedCommand = null;

    public ConsoleCommandParser(Trace t, String input) {
        this(t, input, STRING_DELIMETER);
    }

    public ConsoleCommandParser(Trace t, String input, String strDelim) {
        String fid = "ConsoleCommand.constructor";
        t.entry(64, "ConsoleCommand.constructor");
        if (Trace.isTracing) {
            t.data(64, "ConsoleCommand.constructor", 300, "Command : " + input + ", using delimiter " + strDelim);
        }
        this.stringDelimeter = strDelim;
        this.parsedCommand = this.parseCommand(t, input);
        t.exit(64, "ConsoleCommand.constructor");
    }

    private String[] parseCommand(Trace t, String cmd) {
        String fid = "ConsoleCommandParser.parseCommand";
        t.entry(64, "ConsoleCommandParser.parseCommand");
        String[] ret = null;
        ArrayList<String> a = new ArrayList<String>(10);
        String key = null;
        StringTokenizer st2 = new StringTokenizer(cmd, PARAMETER_DELIMETER, false);
        while (st2.hasMoreTokens()) {
            key = st2.nextToken();
            if (key.startsWith(this.stringDelimeter)) {
                if (!(key = key.substring(1)).endsWith(this.stringDelimeter)) {
                    while (st2.hasMoreTokens()) {
                        String s = st2.nextToken();
                        key = key + PARAMETER_DELIMETER + s;
                        if (!s.endsWith(this.stringDelimeter)) continue;
                        key = key.substring(0, key.length() - 1);
                        break;
                    }
                } else {
                    key = key.substring(0, key.length() - 1);
                }
            }
            a.add(key);
        }
        ret = new String[a.size()];
        a.toArray(ret);
        t.exit(64, "ConsoleCommandParser.parseCommand");
        return ret;
    }

    public String[] getParsedCommand() {
        return this.parsedCommand;
    }
}

