/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.commonservices.internal.console;

import com.ibm.mq.commonservices.Common;
import com.ibm.mq.commonservices.internal.console.ConsoleCommandParser;
import com.ibm.mq.commonservices.internal.console.ConsoleStderrReader;
import com.ibm.mq.commonservices.internal.console.ConsoleStdinWriter;
import com.ibm.mq.commonservices.internal.console.ConsoleStdoutReader;
import com.ibm.mq.commonservices.internal.console.IConsoleCommandListener;
import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.CommonServices;
import java.io.IOException;
import java.util.ArrayList;

public class ConsoleCommand
extends Thread {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005, 2009";
    public static final String SCCSID = "@(#) eclipse/com.ibm.mq.commonservices/src/com/ibm/mq/commonservices/internal/console/ConsoleCommand.java, javagui, p701, p701-112-140304  1.12.1.1 09/08/15 16:30:41";
    private String[] input = null;
    private Process process = null;
    private String command = null;
    private IConsoleCommandListener listener = null;
    private Object listenerId = null;
    private ArrayList expectedExitValues = new ArrayList();
    private String[] environmentVars = null;

    public ConsoleCommand(Trace t, Object id, IConsoleCommandListener ccl, String cmd) {
        String fid = "ConsoleCommand.constructor";
        t.entry(64, "ConsoleCommand.constructor");
        this.command = cmd;
        this.listener = ccl;
        this.listenerId = id;
        switch (CommonServices.PLATFORM_ID) {
            case 1: {
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                this.command = "/usr/bin/" + this.command;
                break;
            }
        }
        this.setDaemon(true);
        if (Trace.isTracing) {
            t.data(64, "ConsoleCommand.constructor", 300, "Command : " + this.command);
        }
        t.exit(64, "ConsoleCommand.constructor");
    }

    public ConsoleCommand(Trace t, Object id, IConsoleCommandListener ccl, String cmd, String[] env) {
        this(t, id, ccl, cmd);
        this.environmentVars = env;
    }

    public ConsoleCommand(Trace t, Object id, IConsoleCommandListener ccl, String cmd, String[] env, String[] args) {
        this(t, id, ccl, cmd);
        this.environmentVars = env;
        this.input = args;
    }

    public void run() {
        Trace t;
        int exitValue;
        block6: {
            String fid = "ConsoleCommand.run";
            exitValue = 0;
            t = Trace.getDefault();
            t.entry(64, "ConsoleCommand.run");
            this.setName("WMQ console command " + this.command);
            try {
                if (this.listener != null) {
                    this.listener.stdout(t, this.listenerId, this.command);
                }
                ConsoleCommandParser ccp = new ConsoleCommandParser(t, this.command);
                String[] cmdLine = ccp.getParsedCommand();
                this.process = this.environmentVars != null ? Runtime.getRuntime().exec(cmdLine, this.environmentVars) : Runtime.getRuntime().exec(cmdLine);
                ConsoleStdoutReader outputReaderThread = new ConsoleStdoutReader(this);
                outputReaderThread.start();
                ConsoleStderrReader errorReaderThread = new ConsoleStderrReader(this);
                errorReaderThread.start();
                ConsoleStdinWriter inputWriterThread = new ConsoleStdinWriter(this, this.input);
                inputWriterThread.start();
                exitValue = this.process.waitFor();
                Thread.yield();
                outputReaderThread.interrupt();
                errorReaderThread.interrupt();
                inputWriterThread.interrupt();
            }
            catch (IOException e) {
                t.FFST(64, "ConsoleCommand.run", 0, 0, "IO exception occurred executing command : " + this.command + Common.LINE_SEPARATOR + e.toString());
            }
            catch (InterruptedException e) {
                if (!Trace.isTracing) break block6;
                t.data(64, "ConsoleCommand.run", e.toString());
            }
        }
        if (Trace.isTracing) {
            t.data(64, "ConsoleCommand.run", 300, "Returning exit value : " + exitValue);
        }
        if (this.listener != null) {
            this.listener.finish(t, this.listenerId, exitValue);
        }
        t.exit(64, "ConsoleCommand.run");
    }

    public boolean addExitValue(int value) {
        return this.expectedExitValues.add(new Integer(value));
    }

    public void cancel(Trace t) {
        if (this.process != null) {
            this.process.destroy();
        }
    }

    public IConsoleCommandListener getListener() {
        return this.listener;
    }

    public Object getListenerId() {
        return this.listenerId;
    }

    public String getCommand() {
        return this.command;
    }

    protected Process getProcess() {
        return this.process;
    }
}

