/*
 * Decompiled with CFR 0.152.
 */
package com.help.autoconfig;

import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.help.aop.ExecuteTimePrintAspect;
import com.help.aop.HelpOperationRecordAspect;
import com.help.common.util.BeanConvert;
import com.help.config.HelpSystemInfo;
import com.help.constraint.IHelpHttpExceptionHandler;
import com.help.constraint.IHelpXssFilter;
import com.help.constraint.IOperationRecordWritter;
import com.help.filter.HelpGlobalExceptionHandleResolver;
import com.help.filter.RequestInfoPrinter;
import com.help.filter.xss.HelpDefaultXssFilter;
import com.help.filter.xss.XssJsonStringDeserializer;
import com.help.filter.xss.XssRequestFilter;
import com.help.handler.HelpDefaultHttpExceptionHandler;
import java.util.List;
import javax.servlet.Filter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.web.ResourceProperties;
import org.springframework.boot.autoconfigure.web.servlet.ConditionalOnMissingFilterBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.core.annotation.Order;
import org.springframework.web.servlet.HandlerExceptionResolver;
import org.springframework.web.servlet.config.annotation.CorsRegistry;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistration;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@ConditionalOnWebApplication
@ConditionalOnClass(value={RequestInfoPrinter.class})
@EnableConfigurationProperties(value={HelpSystemInfo.class})
public class HelpWebAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={IHelpXssFilter.class})
    public HelpDefaultXssFilter helpDefaultXssFilter() {
        return new HelpDefaultXssFilter();
    }

    @Bean
    public ObjectMapper helpDefaultObjectMapper(HelpSystemInfo helpSystemInfo, IHelpXssFilter iHelpXssFilter) {
        if (helpSystemInfo.getXss() == null || !helpSystemInfo.getXss().isEnable() || !helpSystemInfo.getXss().isFilterJson()) {
            return BeanConvert.newObjectMapper();
        }
        SimpleModule simpleModule = BeanConvert.newSimpleModule();
        simpleModule.addDeserializer(String.class, (JsonDeserializer)new XssJsonStringDeserializer(iHelpXssFilter, helpSystemInfo.getXss().getWhitelist()));
        return BeanConvert.newObjectMapper((SimpleModule)simpleModule);
    }

    @Bean
    @ConditionalOnProperty(prefix="help.xss", name={"enable"}, havingValue="true", matchIfMissing=false)
    public FilterRegistrationBean<XssRequestFilter> xssRequestFilterFilterRegistrationBean(HelpSystemInfo helpSystemInfo, IHelpXssFilter iHelpXssFilter) {
        FilterRegistrationBean registration = new FilterRegistrationBean();
        registration.setFilter((Filter)new XssRequestFilter(iHelpXssFilter, new String[]{"*.js", "*.gif", "*.jpg", "*.jpeg", "*.bmp", "*.png", "*.css", "*.ico", "/druid/**"}, helpSystemInfo.getXss().getWhitelist()));
        registration.addUrlPatterns(new String[]{"/*"});
        registration.setName("helpXssRequestFilter");
        registration.setOrder(Integer.MAX_VALUE);
        return registration;
    }

    @Bean
    @ConditionalOnMissingBean
    public ExecuteTimePrintAspect executeTimePrintAspect() {
        return new ExecuteTimePrintAspect();
    }

    @Bean
    @Order(value=0x7FFFFFFF)
    public HelpDefaultHttpExceptionHandler helpDefaultExceptionHandler() {
        return new HelpDefaultHttpExceptionHandler();
    }

    @Bean(name={"requestInfoPrinterFilter"})
    @ConditionalOnMissingFilterBean(value={RequestInfoPrinter.class})
    public FilterRegistrationBean<RequestInfoPrinter> requestInfoPrinterFilterRegistrationBean() {
        FilterRegistrationBean registration = new FilterRegistrationBean();
        registration.setFilter((Filter)new RequestInfoPrinter());
        registration.addUrlPatterns(new String[]{"/*"});
        registration.setName("requestInfoPrinterFilter");
        registration.setOrder(-10);
        return registration;
    }

    @Bean
    public WebMvcConfigurer webConfig(final ResourceProperties resourceProperties, final HelpSystemInfo helpSystemInfo, final List<IHelpHttpExceptionHandler> handlers) {
        return new WebMvcConfigurer(){

            public void addCorsMappings(CorsRegistry registry) {
                if (helpSystemInfo.getCors().isEnable()) {
                    registry.addMapping(helpSystemInfo.getCors().getPathPattern()).allowedOrigins(helpSystemInfo.getCors().getAllowedOrigins()).allowedMethods(helpSystemInfo.getCors().getAllowedMethods()).maxAge(helpSystemInfo.getCors().getMaxAge()).allowCredentials(helpSystemInfo.getCors().isAllowCredentials());
                }
            }

            public void addResourceHandlers(ResourceHandlerRegistry registry) {
                ResourceHandlerRegistration reg = registry.addResourceHandler(new String[]{"/**"});
                for (String l : resourceProperties.getStaticLocations()) {
                    if ("classpath:/META-INF/resources/".equals(l)) continue;
                    reg.addResourceLocations(new String[]{l});
                }
                reg.addResourceLocations(new String[]{"classpath:/META-INF/resources/"});
                reg.addResourceLocations(new String[]{"/"});
                reg.setCacheControl(resourceProperties.getCache().getCachecontrol().toHttpCacheControl());
            }

            public void configureHandlerExceptionResolvers(List<HandlerExceptionResolver> resolvers) {
                resolvers.add((HandlerExceptionResolver)new HelpGlobalExceptionHandleResolver(handlers));
            }
        };
    }

    @Bean
    @ConditionalOnBean(value={IOperationRecordWritter.class})
    public HelpOperationRecordAspect helpOperationRecordAspect() {
        return new HelpOperationRecordAspect();
    }
}

