/*
 * Decompiled with CFR 0.152.
 */
package com.help.autoconfig;

import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.web.client.RestTemplate;

@ConditionalOnClass(value={RestTemplate.class})
@ConditionalOnMissingBean(value={RestTemplate.class})
@AutoConfigureBefore(name={"com.help.autoconfig.HelpCrcbIapAutoConfiguration"})
public class HelpRestTemplateAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={ClientHttpRequestFactory.class})
    public ClientHttpRequestFactory simpleClientHttpRequestFactory() {
        SimpleClientHttpRequestFactory factory = new SimpleClientHttpRequestFactory();
        factory.setConnectTimeout(2000);
        factory.setReadTimeout(30000);
        return factory;
    }

    @Bean
    public RestTemplate restTemplate(ClientHttpRequestFactory factory) {
        return new RestTemplate(factory);
    }
}

