/*
 * Decompiled with CFR 0.152.
 */
package com.help.autoconfig;

import com.help.adapter.HelpCrcbAmazonStorageAdapter;
import com.help.conditional.ConditionalOnMatchOrEmpty;
import com.help.config.HelpCrcbAmazonConfig;
import com.help.storage.HelpCrcbAmazonClient;
import com.help.storage.IFileStorage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;

@ConditionalOnClass(value={HelpCrcbAmazonClient.class})
@ConditionalOnMatchOrEmpty(value="help.file.amazon.enable", havingValue={"true"})
public class HelpCrcbAmazonFileStorageAutoConfiguration {
    Logger logger = LoggerFactory.getLogger(HelpCrcbAmazonFileStorageAutoConfiguration.class);

    @Bean
    @ConfigurationProperties(value="help.file.amazon")
    @ConditionalOnProperty(prefix="help.file.amazon", value={"url", "access-key", "secret-key", "bucket-name"})
    public HelpCrcbAmazonConfig helpCrcbAmazonConfig() {
        return new HelpCrcbAmazonConfig();
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnBean(value={HelpCrcbAmazonConfig.class})
    public HelpCrcbAmazonClient helpCrcbAmazonClient(HelpCrcbAmazonConfig helpCrcbAmazonConfig) {
        HelpCrcbAmazonClient client = new HelpCrcbAmazonClient(helpCrcbAmazonConfig);
        this.logger.info("\u68c0\u6d4b\u5230[\u5e38\u719f\u519c\u5546\u884c\u5bf9\u8c61\u5b58\u50a8\u5ba2\u6237\u7aef],\u81ea\u52a8\u914d\u7f6e[\u9644\u4ef6\u5b58\u50a8\u5668-\u5e38\u719f\u519c\u5546\u884c\u5bf9\u8c61\u5b58\u50a8],\u670d\u52a1\u5668\u5730\u5740[" + helpCrcbAmazonConfig.getUrl() + "]");
        return client;
    }

    @Bean
    @ConditionalOnMissingBean(value={IFileStorage.class})
    public HelpCrcbAmazonStorageAdapter HelpCrcbAmazonStorageAdapter(HelpCrcbAmazonClient helpCrcbAmazonClient) {
        return new HelpCrcbAmazonStorageAdapter(helpCrcbAmazonClient);
    }
}

