/*
 * Decompiled with CFR 0.152.
 */
package com.help.adapter;

import com.help.common.exception.UnifyErrorCode;
import com.help.common.exception.UnifyException;
import com.help.file.HelpFileClient;
import com.help.file.HelpFileRole;
import com.help.storage.IFileStorage;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.springframework.util.StreamUtils;

public class HelpFileClientStorageAdapter
implements IFileStorage {
    private HelpFileClient client;

    public HelpFileClientStorageAdapter(HelpFileClient client) {
        this.client = client;
    }

    public String save(byte[] file, String originalFileName) {
        return this.client.upload(HelpFileRole.SECURITY, file, originalFileName);
    }

    public String save(InputStream is, String originalFileName) {
        byte[] file = null;
        try {
            file = StreamUtils.copyToByteArray((InputStream)is);
        }
        catch (Exception e) {
            throw new UnifyException(UnifyErrorCode.UNKNOW_FAIL, "\u6587\u4ef6\u4fdd\u5b58\u5931\u8d25:[" + e.getMessage() + "]");
        }
        return this.save(file, originalFileName);
    }

    public String save(InputStream is, String originalFileName, long size) {
        return this.save(is, originalFileName);
    }

    public void delete(String fileId) {
        this.client.delete(fileId);
    }

    public byte[] get(String fileId) {
        return this.client.download(fileId).getData();
    }

    public InputStream getInputStream(String fileId) {
        return new ByteArrayInputStream(this.get(fileId));
    }

    public long getSize(String fileId) {
        return this.client.metadata(fileId).getSize();
    }

    public void setPermission(boolean publicRead, String ... fileIds) {
    }
}

