/*
 * Decompiled with CFR 0.152.
 */
package com.help.adapter;

import com.amazonaws.services.s3.model.CannedAccessControlList;
import com.help.constraint.IHelpSystemComponent;
import com.help.storage.HelpAmazonRequest;
import com.help.storage.HelpCrcbAmazonClient;
import com.help.storage.IFileStorage;
import java.io.InputStream;

public class HelpCrcbAmazonStorageAdapter
implements IFileStorage,
IHelpSystemComponent {
    HelpCrcbAmazonClient client;

    public HelpCrcbAmazonStorageAdapter(HelpCrcbAmazonClient client) {
        this.client = client;
    }

    public String save(byte[] file, String originalFileName) {
        return this.client.save(file, originalFileName);
    }

    public String save(InputStream is, String originalFileName) {
        return this.client.save(is, originalFileName);
    }

    public String save(InputStream is, String originalFileName, long size) {
        HelpAmazonRequest request = new HelpAmazonRequest().withInputStream(is).withOriginalFileName(originalFileName).withSize(size);
        return this.client.save(request);
    }

    public void delete(String fileId) {
        this.client.delete(fileId);
    }

    public byte[] get(String fileId) {
        return this.client.get(fileId);
    }

    public InputStream getInputStream(String fileId) {
        return this.client.getInputStream(fileId);
    }

    public long getSize(String fileId) {
        return this.client.getSize(fileId);
    }

    public void setPermission(boolean publicRead, String ... fileIds) {
        if (fileIds != null) {
            for (String id : fileIds) {
                this.client.setPermission(id, publicRead ? CannedAccessControlList.PublicRead : CannedAccessControlList.Private);
            }
        }
    }

    public String getName() {
        return "\u6587\u4ef6\u5b58\u50a8-\u5206\u5e03\u5f0f-Amazon\u5bf9\u8c61\u5b58\u50a8";
    }
}

