/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.condition;

import com.help.conditional.ConditionalOnGenericityBean;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.HierarchicalBeanFactory;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.boot.autoconfigure.AutoConfigurationMetadata;
import org.springframework.boot.autoconfigure.condition.BeanTypeRegistry;
import org.springframework.boot.autoconfigure.condition.ConditionMessage;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.FilteringSpringBootCondition;
import org.springframework.boot.autoconfigure.condition.SearchStrategy;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.ConfigurationCondition;
import org.springframework.core.ResolvableType;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.annotation.Order;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.core.type.MethodMetadata;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.MultiValueMap;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

@Order(value=0x7FFFFFFE)
public class OnGenericityBeanCondition
extends FilteringSpringBootCondition
implements ConfigurationCondition {
    public ConfigurationCondition.ConfigurationPhase getConfigurationPhase() {
        return ConfigurationCondition.ConfigurationPhase.REGISTER_BEAN;
    }

    protected final ConditionOutcome[] getOutcomes(String[] autoConfigurationClasses, AutoConfigurationMetadata autoConfigurationMetadata) {
        ConditionOutcome[] outcomes = new ConditionOutcome[autoConfigurationClasses.length];
        for (int i = 0; i < outcomes.length; ++i) {
            String autoConfigurationClass = autoConfigurationClasses[i];
            if (autoConfigurationClass == null) continue;
            Set onBeanTypes = autoConfigurationMetadata.getSet(autoConfigurationClass, "ConditionalOnGenericityBean");
            outcomes[i] = this.getOutcome(onBeanTypes, ConditionalOnGenericityBean.class);
        }
        return outcomes;
    }

    private ConditionOutcome getOutcome(Set<String> requiredBeanTypes, Class<? extends Annotation> annotation) {
        List missing = this.filter(requiredBeanTypes, FilteringSpringBootCondition.ClassNameFilter.MISSING, this.getBeanClassLoader());
        if (!missing.isEmpty()) {
            ConditionMessage message = ConditionMessage.forCondition(annotation, (Object[])new Object[0]).didNotFind("required type", "required types").items(ConditionMessage.Style.QUOTE, (Collection)missing);
            return ConditionOutcome.noMatch((ConditionMessage)message);
        }
        return null;
    }

    public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
        ConditionMessage matchMessage = ConditionMessage.empty();
        if (metadata.isAnnotated(ConditionalOnGenericityBean.class.getName())) {
            BeanSearchSpec spec = new BeanSearchSpec(context, metadata, ConditionalOnGenericityBean.class);
            MatchResult matchResult = this.getMatchingBeans(context, spec);
            if (!matchResult.isAllMatched()) {
                String reason = this.createOnBeanNoMatchReason(matchResult);
                return ConditionOutcome.noMatch((ConditionMessage)ConditionMessage.forCondition(ConditionalOnGenericityBean.class, (Object[])new Object[]{spec}).because(reason));
            }
            matchMessage = matchMessage.andCondition(ConditionalOnGenericityBean.class, new Object[]{spec}).found("bean", "beans").items(ConditionMessage.Style.QUOTE, matchResult.getNamesOfAllMatches());
        }
        return ConditionOutcome.match((ConditionMessage)matchMessage);
    }

    protected final MatchResult getMatchingBeans(ConditionContext context, BeanSearchSpec beans) {
        ConfigurableListableBeanFactory beanFactory = context.getBeanFactory();
        if (beans.getStrategy() == SearchStrategy.ANCESTORS) {
            BeanFactory parent = beanFactory.getParentBeanFactory();
            Assert.isInstanceOf(ConfigurableListableBeanFactory.class, (Object)parent, (String)"Unable to use SearchStrategy.ANCESTORS");
            beanFactory = (ConfigurableListableBeanFactory)parent;
        }
        MatchResult matchResult = new MatchResult();
        boolean considerHierarchy = beans.getStrategy() != SearchStrategy.CURRENT;
        BeanTypeRegistry.TypeExtractor typeExtractor = beans.getTypeExtractor(context.getClassLoader());
        for (String type : beans.getTypes()) {
            Collection<String> typeMatches = this.getBeanNamesForType((ListableBeanFactory)beanFactory, type, typeExtractor, context.getClassLoader(), considerHierarchy);
            if (typeMatches.isEmpty()) {
                matchResult.recordUnmatchedType(type);
                continue;
            }
            matchResult.recordMatchedType(type, typeMatches);
        }
        return matchResult;
    }

    private Collection<String> getBeanNamesForType(ListableBeanFactory beanFactory, String type, BeanTypeRegistry.TypeExtractor typeExtractor, ClassLoader classLoader, boolean considerHierarchy) throws LinkageError {
        try {
            return this.getBeanNamesForType(beanFactory, considerHierarchy, ClassUtils.forName((String)type, (ClassLoader)classLoader), typeExtractor);
        }
        catch (ClassNotFoundException | NoClassDefFoundError ex) {
            return Collections.emptySet();
        }
    }

    private Collection<String> getBeanNamesForType(ListableBeanFactory beanFactory, boolean considerHierarchy, Class<?> type, BeanTypeRegistry.TypeExtractor typeExtractor) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        this.collectBeanNamesForType(result, beanFactory, type, typeExtractor, considerHierarchy);
        return result;
    }

    private void collectBeanNamesForType(Set<String> result, ListableBeanFactory beanFactory, Class<?> type, BeanTypeRegistry.TypeExtractor typeExtractor, boolean considerHierarchy) {
        BeanFactory parent;
        BeanTypeRegistry registry = BeanTypeRegistry.get((ListableBeanFactory)beanFactory);
        result.addAll(registry.getNamesForType(type, typeExtractor));
        if (considerHierarchy && beanFactory instanceof HierarchicalBeanFactory && (parent = ((HierarchicalBeanFactory)beanFactory).getParentBeanFactory()) instanceof ListableBeanFactory) {
            this.collectBeanNamesForType(result, (ListableBeanFactory)parent, type, typeExtractor, considerHierarchy);
        }
    }

    private String createOnBeanNoMatchReason(MatchResult matchResult) {
        StringBuilder reason = new StringBuilder();
        this.appendMessageForNoMatches(reason, matchResult.getUnmatchedAnnotations(), "annotated with");
        this.appendMessageForNoMatches(reason, matchResult.getUnmatchedTypes(), "of type");
        this.appendMessageForNoMatches(reason, matchResult.getUnmatchedNames(), "named");
        return reason.toString();
    }

    private void appendMessageForNoMatches(StringBuilder reason, Collection<String> unmatched, String description) {
        if (!unmatched.isEmpty()) {
            if (reason.length() > 0) {
                reason.append(" and ");
            }
            reason.append("did not find any beans ");
            reason.append(description);
            reason.append(" ");
            reason.append(StringUtils.collectionToDelimitedString(unmatched, (String)", "));
        }
    }

    static final class BeanTypeDeductionException
    extends RuntimeException {
        private BeanTypeDeductionException(String className, String beanMethodName, Throwable cause) {
            super("Failed to deduce bean type for " + className + "." + beanMethodName, cause);
        }
    }

    protected static final class MatchResult {
        private final Map<String, Collection<String>> matchedAnnotations = new HashMap<String, Collection<String>>();
        private final List<String> matchedNames = new ArrayList<String>();
        private final Map<String, Collection<String>> matchedTypes = new HashMap<String, Collection<String>>();
        private final List<String> unmatchedAnnotations = new ArrayList<String>();
        private final List<String> unmatchedNames = new ArrayList<String>();
        private final List<String> unmatchedTypes = new ArrayList<String>();
        private final Set<String> namesOfAllMatches = new HashSet<String>();

        protected MatchResult() {
        }

        private void recordMatchedName(String name) {
            this.matchedNames.add(name);
            this.namesOfAllMatches.add(name);
        }

        private void recordUnmatchedName(String name) {
            this.unmatchedNames.add(name);
        }

        private void recordMatchedAnnotation(String annotation, Collection<String> matchingNames) {
            this.matchedAnnotations.put(annotation, matchingNames);
            this.namesOfAllMatches.addAll(matchingNames);
        }

        private void recordUnmatchedAnnotation(String annotation) {
            this.unmatchedAnnotations.add(annotation);
        }

        private void recordMatchedType(String type, Collection<String> matchingNames) {
            this.matchedTypes.put(type, matchingNames);
            this.namesOfAllMatches.addAll(matchingNames);
        }

        private void recordUnmatchedType(String type) {
            this.unmatchedTypes.add(type);
        }

        public boolean isAllMatched() {
            return this.unmatchedAnnotations.isEmpty() && this.unmatchedNames.isEmpty() && this.unmatchedTypes.isEmpty();
        }

        public boolean isAnyMatched() {
            return !this.matchedAnnotations.isEmpty() || !this.matchedNames.isEmpty() || !this.matchedTypes.isEmpty();
        }

        public Map<String, Collection<String>> getMatchedAnnotations() {
            return this.matchedAnnotations;
        }

        public List<String> getMatchedNames() {
            return this.matchedNames;
        }

        public Map<String, Collection<String>> getMatchedTypes() {
            return this.matchedTypes;
        }

        public List<String> getUnmatchedAnnotations() {
            return this.unmatchedAnnotations;
        }

        public List<String> getUnmatchedNames() {
            return this.unmatchedNames;
        }

        public List<String> getUnmatchedTypes() {
            return this.unmatchedTypes;
        }

        public Set<String> getNamesOfAllMatches() {
            return this.namesOfAllMatches;
        }
    }

    private static class SingleCandidateBeanSearchSpec
    extends BeanSearchSpec {
        SingleCandidateBeanSearchSpec(ConditionContext context, AnnotatedTypeMetadata metadata, Class<?> annotationType) {
            super(context, metadata, annotationType);
        }

        @Override
        protected void collect(MultiValueMap<String, Object> attributes, String key, List<String> destination) {
            super.collect(attributes, key, destination);
            destination.removeAll(Arrays.asList("", Object.class.getName()));
        }

        @Override
        protected void validate(BeanTypeDeductionException ex) {
            Assert.isTrue((this.getTypes().size() == 1 ? 1 : 0) != 0, () -> this.getAnnotationName() + " annotations must specify only one type (got " + this.getTypes() + ")");
        }
    }

    protected static class BeanSearchSpec {
        private final Class<?> annotationType;
        private final List<String> types = new ArrayList<String>();
        private final List<String> parameterizedContainers = new ArrayList<String>();
        private final SearchStrategy strategy;

        public BeanSearchSpec(ConditionContext context, AnnotatedTypeMetadata metadata, Class<?> annotationType) {
            this(context, metadata, annotationType, null);
        }

        public BeanSearchSpec(ConditionContext context, AnnotatedTypeMetadata metadata, Class<?> annotationType, Class<?> genericContainer) {
            this.annotationType = annotationType;
            MultiValueMap attributes = metadata.getAllAnnotationAttributes(annotationType.getName(), true);
            this.collect((MultiValueMap<String, Object>)attributes, "value", this.types);
            this.collect((MultiValueMap<String, Object>)attributes, "type", this.types);
            this.collect((MultiValueMap<String, Object>)attributes, "parameterizedContainer", this.parameterizedContainers);
            this.strategy = (SearchStrategy)attributes.getFirst((Object)"search");
            BeanTypeDeductionException deductionException = null;
            try {
                if (this.types.isEmpty()) {
                    this.addDeducedBeanType(context, metadata, this.types);
                }
            }
            catch (BeanTypeDeductionException ex) {
                deductionException = ex;
            }
            this.validate(deductionException);
        }

        protected void validate(BeanTypeDeductionException ex) {
            if (!this.hasAtLeastOne(this.types)) {
                String message = this.getAnnotationName() + " did not specify a bean using type, name or annotation";
                if (ex == null) {
                    throw new IllegalStateException(message);
                }
                throw new IllegalStateException(message + " and the attempt to deduce the bean's type failed", ex);
            }
        }

        private boolean hasAtLeastOne(List<?> ... lists) {
            return Arrays.stream(lists).anyMatch(list -> !list.isEmpty());
        }

        protected final String getAnnotationName() {
            return "@" + ClassUtils.getShortName(this.annotationType);
        }

        protected void collect(MultiValueMap<String, Object> attributes, String key, List<String> destination) {
            List values = (List)attributes.get((Object)key);
            if (values != null) {
                for (Object value : values) {
                    if (value instanceof String[]) {
                        Collections.addAll(destination, (String[])value);
                        continue;
                    }
                    destination.add((String)value);
                }
            }
        }

        private void addDeducedBeanType(ConditionContext context, AnnotatedTypeMetadata metadata, List<String> beanTypes) {
            if (metadata instanceof MethodMetadata && metadata.isAnnotated(Bean.class.getName())) {
                this.addDeducedBeanTypeForBeanMethod(context, (MethodMetadata)metadata, beanTypes);
            }
        }

        private void addDeducedBeanTypeForBeanMethod(ConditionContext context, MethodMetadata metadata, List<String> beanTypes) {
            try {
                Class<?> returnType = this.getReturnType(context, metadata);
                beanTypes.add(returnType.getName());
            }
            catch (Throwable ex) {
                throw new BeanTypeDeductionException(metadata.getDeclaringClassName(), metadata.getMethodName(), ex);
            }
        }

        private Class<?> getReturnType(ConditionContext context, MethodMetadata metadata) throws ClassNotFoundException, LinkageError {
            ClassLoader classLoader = context.getClassLoader();
            Class<?> returnType = ClassUtils.forName((String)metadata.getReturnTypeName(), (ClassLoader)classLoader);
            if (this.isParameterizedContainer(returnType, classLoader)) {
                returnType = this.getReturnTypeGeneric(metadata, classLoader);
            }
            return returnType;
        }

        private Class<?> getReturnTypeGeneric(MethodMetadata metadata, ClassLoader classLoader) throws ClassNotFoundException, LinkageError {
            Class declaringClass = ClassUtils.forName((String)metadata.getDeclaringClassName(), (ClassLoader)classLoader);
            Method beanMethod = this.findBeanMethod(declaringClass, metadata.getMethodName());
            return ResolvableType.forMethodReturnType((Method)beanMethod).resolveGeneric(new int[0]);
        }

        private Method findBeanMethod(Class<?> declaringClass, String methodName) {
            Method method = ReflectionUtils.findMethod(declaringClass, (String)methodName);
            if (this.isBeanMethod(method)) {
                return method;
            }
            return Arrays.stream(ReflectionUtils.getAllDeclaredMethods(declaringClass)).filter(candidate -> candidate.getName().equals(methodName)).filter(this::isBeanMethod).findFirst().orElseThrow(() -> new IllegalStateException("Unable to find bean method " + methodName));
        }

        private boolean isBeanMethod(Method method) {
            return method != null && AnnotatedElementUtils.hasAnnotation((AnnotatedElement)method, Bean.class);
        }

        public BeanTypeRegistry.TypeExtractor getTypeExtractor(ClassLoader classLoader) {
            if (this.parameterizedContainers.isEmpty()) {
                return ResolvableType::resolve;
            }
            return type -> {
                Class resolved = type.resolve();
                if (this.isParameterizedContainer(resolved, classLoader)) {
                    return type.getGeneric(new int[0]).resolve();
                }
                return resolved;
            };
        }

        private boolean isParameterizedContainer(Class<?> type, ClassLoader classLoader) {
            for (String candidate : this.parameterizedContainers) {
                try {
                    if (!ClassUtils.forName((String)candidate, (ClassLoader)classLoader).isAssignableFrom(type)) continue;
                    return true;
                }
                catch (Exception exception) {
                }
            }
            return false;
        }

        public SearchStrategy getStrategy() {
            return this.strategy != null ? this.strategy : SearchStrategy.ALL;
        }

        public List<String> getTypes() {
            return this.types;
        }

        public String toString() {
            StringBuilder string = new StringBuilder();
            string.append("(");
            if (!this.types.isEmpty()) {
                string.append("types: ");
                string.append(StringUtils.collectionToCommaDelimitedString(this.types));
            }
            string.append("; SearchStrategy: ");
            string.append(this.strategy.toString().toLowerCase(Locale.ENGLISH));
            string.append(")");
            return string.toString();
        }
    }
}

