/*
 * Decompiled with CFR 0.152.
 */
package com.help.storage;

import com.help.common.exception.UnifyErrorCode;
import com.help.common.exception.UnifyException;
import com.help.common.util.FileUtil;
import com.help.common.util.StreamUtils;
import com.help.common.util.StringUtil;
import com.help.storage.IFileStorage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.UUID;

public class LocalFileStorage
implements IFileStorage {
    private String root;

    public LocalFileStorage(String root) {
        if (StringUtil.isEmpty((String)root)) {
            root = "/";
        }
        if (!root.endsWith("/") && !root.endsWith("\\")) {
            root = root + File.separatorChar;
        }
        this.root = root;
    }

    private String getFileName(String id) {
        String dir = this.root + id.substring(id.length() - 3);
        FileUtil.mkdir((String)dir);
        return dir + File.separatorChar + id;
    }

    @Override
    public String save(byte[] file, String originalFileName) {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(file);
        return this.save(byteArrayInputStream, originalFileName);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String save(InputStream is, String originalFileName) {
        String id = UUID.randomUUID().toString().replace("-", "");
        try (FileOutputStream fos = new FileOutputStream(this.getFileName(id));){
            StreamUtils.copy((InputStream)is, (OutputStream)fos);
            String string = id;
            return string;
        }
        catch (Exception e) {
            throw new UnifyException(UnifyErrorCode.UNKNOW_FAIL, "\u6587\u4ef6\u4fdd\u5b58\u5931\u8d25:[" + e.getMessage() + "]");
        }
    }

    @Override
    public void delete(String fileId) {
        File file = new File(this.getFileName(fileId));
        if (file.exists()) {
            file.delete();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public byte[] get(String fileId) {
        try (InputStream is = this.getInputStream(fileId);){
            byte[] byArray = StreamUtils.copyToByteArray((InputStream)is);
            return byArray;
        }
        catch (IOException e) {
            throw new UnifyException("\u6587\u4ef6[" + fileId + "]\u8bfb\u53d6\u5931\u8d25");
        }
    }

    @Override
    public InputStream getInputStream(String fileId) {
        try {
            return new FileInputStream(this.getFileName(fileId));
        }
        catch (FileNotFoundException e) {
            throw new UnifyException(UnifyErrorCode.NON_DATA, "\u6587\u4ef6[" + fileId + "]\u4e0d\u5b58\u5728");
        }
    }

    @Override
    public long getSize(String fileId) {
        File file = new File(this.getFileName(fileId));
        if (file.exists()) {
            return file.length();
        }
        throw new UnifyException("\u6587\u4ef6[" + fileId + "]\u4e0d\u5b58\u5728");
    }
}

