package com.help.storage;

import java.io.InputStream;

/**
 * HELP平台附件模块文件存储接口
 */
public interface IFileStorage {

    /**
     * 保存文件
     *
     * @param file             文件数据
     * @param originalFileName 文件的原始文件名(不包含路径)
     * @return 文件唯一ID(长度在50以下)
     */
    String save(byte[] file, String originalFileName);

    /**
     * 从输入流中读取文件并保存
     *
     * @param is               输入流 流的关闭应由该方法的调用方实现,该方法在操作完成后不会关闭流
     * @param originalFileName 文件的原始文件名(不包含路径)
     * @return
     */
    String save(InputStream is, String originalFileName);

    /**
     * 通过文件唯一ID删除文件
     *
     * @param fileId 文件唯一ID
     */
    void delete(String fileId);

    /**
     * 通过文件唯一ID读取文件
     *
     * @param fileId 文件唯一ID
     * @return
     */
    byte[] get(String fileId);

    /**
     * 获取文件并构造为输入流(调用方在使用完成后应手动关闭该流)
     *
     * @param fileId
     * @return
     */
    InputStream getInputStream(String fileId);

    /**
     * 获取文件大小
     *
     * @param fileId
     * @return
     */
    long getSize(String fileId);
}
