package com.help.constraint;

/**
 * 交易流水号生成器
 * @author JBF-YB
 *
 */
public interface ISerNoGenerator {

	/**
	 * 使用默认序列号类型生成一个唯一的自增序列值
	 * @return
	 */
	long getSequence();

	/**
	 * 生成一个在给定的序列号类型下唯一的自增序列值
	 * @param type
	 * @return
	 */
	long getSequence(String type);

	/**
	 * 生成一个在给定的交易类型下唯一的交易流水号
	 * 不通的交易类型 其流水号允许重复
	 * @param type 交易类型
	 * @return
	 */
	String getSerno(String type);
	
	/**
	 * 使用默认交易类型一个全局唯一的交易流水号
	 * @return
	 */
	String getSerno();
	
	/**
	 * 生成一个随机流水号(无需全局唯一)
	 * @return
	 */
	String getRandomSerno();
}
