package com.help.conditional;

import org.springframework.beans.factory.BeanFactory;
import org.springframework.boot.autoconfigure.condition.OnGenericityBeanCondition;
import org.springframework.boot.autoconfigure.condition.SearchStrategy;
import org.springframework.context.annotation.Conditional;

import java.lang.annotation.*;

/**
 * @author: YuBin-002726
 * @Date: 2019/9/24 16:34
 */
@Retention(RetentionPolicy.RUNTIME)
@Target({ElementType.TYPE, ElementType.METHOD})
@Documented
@Conditional(OnGenericityBeanCondition.class)
public @interface ConditionalOnGenericityBean {

    /**
     * The class types of beans that should be checked. The condition matches when beans
     * of all classes specified are contained in the {@link BeanFactory}.
     * @return the class types of beans to check
     */
    Class<?>[] value() default {};

    /**
     * Strategy to decide if the application context hierarchy (parent contexts) should be
     * considered.
     * @return the search strategy
     */
    SearchStrategy search() default SearchStrategy.ALL;

    /**
     * Additional classes that may contain the specified bean types within their generic
     * parameters. For example, an annotation declaring {@code value=Name.class} and
     * {@code parameterizedContainer=NameRegistration.class} would detect both
     * {@code Name} and {@code NameRegistration<Name>}.
     * @return the container types
     * @since 2.1.0
     */
    Class<?>[] parameterizedContainer() default {};

}
