package com.help.common.concurrent;

/**
 * HELP平台分布式可重入锁接口
 *
 * @author: YuBin-002726
 * @Date: 2019/7/8 10:11
 */
public interface IHelpLocker {

    /**
     * 获取指定名称的锁
     * 此方法将阻塞当前线程直到获取锁,tryLock替代
     *
     * @param name      锁名称
     * @param leaseTime 最长锁定时间(毫秒)
     * @throws InterruptedException 当前线程在阻塞过程中收到中断请求则抛出
     * @see #tryLock(String, long)
     */
    void lock(String name, long leaseTime) throws InterruptedException;

    /**
     * 尝试获取锁
     * 当无法获取锁,将立即返回
     *
     * @param name        锁名称
     * @param leaseTimeMs 最长锁定时间(毫秒)
     * @return
     */
    boolean tryLock(String name, long leaseTimeMs);

    /**
     * 尝试获取锁
     * 此方法将在{@code waitMs}时间内阻塞线程并不断尝试获取锁,超时仍未获取到则返回
     *
     * @param name        锁名称
     * @param waitMs      获取锁最长等待时间(毫秒)
     * @param leaseTimeMs 最长锁定时间(毫秒)
     * @return
     * @throws InterruptedException 当前线程在阻塞过程中收到中断请求则抛出
     */
    boolean tryLock(String name, long waitMs, long leaseTimeMs) throws InterruptedException;

    /**
     * 解锁
     * 无法跨线程解锁
     *
     * @param name
     */
    void unlock(String name);

}
