/*
 * Decompiled with CFR 0.152.
 */
package com.help.autoconfig;

import com.help.common.HelpSleuthConfig;
import com.help.filter.TraceIdMDCFilter;
import javax.servlet.Filter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.web.servlet.ConditionalOnMissingFilterBean;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;

@ConditionalOnWebApplication
@ConditionalOnClass(value={TraceIdMDCFilter.class})
@AutoConfigureAfter(name={"org.springframework.cloud.sleuth.autoconfig.TraceAutoConfiguration"})
public class HelpTraceAutoConfiguration {
    Logger logger = LoggerFactory.getLogger(HelpTraceAutoConfiguration.class);

    @Bean
    @ConditionalOnMissingBean
    @ConfigurationProperties(value="help.sleuth")
    public HelpSleuthConfig helpSleuthConfig() {
        return new HelpSleuthConfig();
    }

    @Bean(name={"traceIdMDCFilterBean"})
    @ConditionalOnMissingBean(type={"org.springframework.cloud.sleuth.autoconfig.TraceAutoConfiguration"})
    @ConditionalOnMissingFilterBean(value={TraceIdMDCFilter.class})
    public FilterRegistrationBean<TraceIdMDCFilter> traceIdMDCFilterBean(HelpSleuthConfig config) {
        FilterRegistrationBean registration = new FilterRegistrationBean();
        registration.setFilter((Filter)new TraceIdMDCFilter(config));
        registration.addUrlPatterns(new String[]{"/*"});
        registration.setName("traceIdMDCFilter");
        registration.setOrder(2);
        this.logger.info("\u672a\u68c0\u6d4b\u5230[Spring-Sleuth]\u7ec4\u4ef6,\u542f\u7528[HELP\u5e73\u53f0\u94fe\u8def\u8ffd\u8e2a\u5668]");
        return registration;
    }
}

