/*
 * Decompiled with CFR 0.152.
 */
package com.helpframework.storage;

import com.help.AbstractLoginToken;
import com.help.constraint.IHelpSystemComponent;
import com.helpframework.storage.ITokenStorege;
import java.util.concurrent.TimeUnit;
import org.redisson.api.RBucket;
import org.redisson.api.RedissonClient;
import org.springframework.beans.factory.annotation.Value;

public class RedissonTokenStorage<T extends AbstractLoginToken>
implements ITokenStorege<T>,
IHelpSystemComponent {
    private RedissonClient redissonClient;
    @Value(value="${spring.application.name:HELP}")
    private String appName;

    public RedissonTokenStorage(RedissonClient redissonClient) {
        this.redissonClient = redissonClient;
    }

    private RBucket<T> getBucket(String token) {
        return this.redissonClient.getBucket(this.appName + "_LOGIN_TOKEN:" + token);
    }

    @Override
    public void save(T token, long expireMs) {
        this.getBucket(token.getToken()).set(token, expireMs, TimeUnit.MILLISECONDS);
    }

    @Override
    public void delete(String key) {
        this.getBucket(key).delete();
    }

    @Override
    public T get(String key) {
        return (T)((AbstractLoginToken)this.getBucket(key).get());
    }

    @Override
    public void refresh(String key, long expireMs) {
        this.getBucket(key).expire(expireMs, TimeUnit.MILLISECONDS);
    }

    public String getName() {
        return "Token\u4fdd\u6301\u670d\u52a1-\u5206\u5e03\u5f0f-Redisson";
    }
}

