/*
 * Decompiled with CFR 0.152.
 */
package com.help.autoconfig;

import com.help.ITokenContext;
import com.help.common.util.StringUtil;
import com.help.filter.HelpTokenMDCFilter;
import com.helpframework.HelpRedissonTokenConfig;
import com.helpframework.UserTokenContext;
import com.helpframework.aop.TokenRefreshAspect;
import com.helpframework.storage.ITokenStorege;
import javax.servlet.Filter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Scope;
import org.springframework.context.annotation.ScopedProxyMode;

@ConditionalOnClass(value={TokenRefreshAspect.class})
public class HelpRedissonTokenAutoConfiguration {
    Logger logger = LoggerFactory.getLogger(HelpRedissonTokenAutoConfiguration.class);
    @Value(value="${spring.application.name:HELP}")
    private String appName;

    @Bean
    @ConditionalOnMissingBean
    @ConfigurationProperties(value="help.token")
    public HelpRedissonTokenConfig helpRedissonTokenConfig() {
        return new HelpRedissonTokenConfig();
    }

    @Bean
    @ConditionalOnMissingBean(value={ITokenContext.class})
    @ConditionalOnBean(value={HelpRedissonTokenConfig.class, ITokenStorege.class})
    @Scope(value="request", proxyMode=ScopedProxyMode.TARGET_CLASS)
    public UserTokenContext userTokenContext(ITokenStorege iTokenStorege) {
        return new UserTokenContext(iTokenStorege);
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnBean(value={HelpRedissonTokenConfig.class, UserTokenContext.class})
    public TokenRefreshAspect tokenRefreshAspect(HelpRedissonTokenConfig config) {
        this.logger.info("\u68c0\u6d4b\u5230Token\u6a21\u5757,\u81ea\u52a8\u914d\u7f6e[HELP-Token\u7ba1\u7406\u5668],Token\u6765\u6e90[" + StringUtil.join((Object[])config.getTokenMode(), (String)",") + "],\u6620\u5c04\u8bf7\u6c42\u53c2\u6570[" + config.getField() + "],\u8d85\u65f6\u65f6\u95f4[" + config.getInvalidTime() + "ms]");
        return new TokenRefreshAspect();
    }

    @Bean(name={"tokenMDCRegister"})
    @ConditionalOnBean(value={HelpRedissonTokenConfig.class})
    @ConditionalOnMissingBean(value={HelpTokenMDCFilter.class}, parameterizedContainer={FilterRegistrationBean.class})
    public FilterRegistrationBean<HelpTokenMDCFilter> tokenMDCFilterBean(HelpRedissonTokenConfig config) {
        FilterRegistrationBean registration = new FilterRegistrationBean();
        registration.setFilter((Filter)new HelpTokenMDCFilter(config.getField()));
        registration.addUrlPatterns(new String[]{"/*"});
        registration.setName("tokenMDCFilter");
        registration.setOrder(2);
        return registration;
    }
}

