/*
 * Decompiled with CFR 0.152.
 */
package com.helpframework.storage;

import com.help.AbstractLoginToken;
import com.help.constraint.IHelpSystemComponent;
import com.helpframework.storage.ITokenStorege;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Scheduled;

public class LocalTokenStorage<T extends AbstractLoginToken>
implements ITokenStorege<T>,
IHelpSystemComponent {
    Logger logger = LoggerFactory.getLogger(LocalTokenStorage.class);
    private Map<String, T> tokens = new ConcurrentHashMap<String, T>();
    private Map<String, Long> timeouts = new ConcurrentHashMap<String, Long>();

    @Scheduled(fixedRate=120000L)
    public void clean() {
        Iterator<Map.Entry<String, Long>> iterator = this.timeouts.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, Long> entry = iterator.next();
            Long timeout = entry.getValue();
            if (timeout == null || timeout > System.currentTimeMillis()) continue;
            this.tokens.remove(entry.getKey());
            iterator.remove();
            this.logger.warn("\u5df2\u5220\u9664Token");
        }
    }

    public void save(T token, long expireMs) {
        this.timeouts.put(token.getToken(), System.currentTimeMillis() + expireMs);
        this.tokens.put(token.getToken(), token);
    }

    public void delete(String key) {
        this.tokens.remove(key);
        this.timeouts.remove(key);
    }

    public T get(String key) {
        Long timeout = this.timeouts.get(key);
        if (timeout == null) {
            return null;
        }
        if (timeout <= System.currentTimeMillis()) {
            this.tokens.remove(key);
            this.timeouts.remove(key);
            return null;
        }
        return (T)((AbstractLoginToken)this.tokens.get(key));
    }

    public void refresh(String key, long expireMs) {
        if (this.tokens.containsKey(key)) {
            Long timeout = this.timeouts.get(key);
            if (timeout != null && timeout > System.currentTimeMillis()) {
                this.timeouts.put(key, System.currentTimeMillis() + expireMs);
            } else {
                this.delete(key);
            }
        }
    }

    public String getName() {
        return "Token\u4fdd\u6301\u670d\u52a1-\u672c\u5730\u5185\u5b58";
    }
}

