/*
 * Decompiled with CFR 0.152.
 */
package com.helpframework.storage;

import com.help.AbstractLoginToken;
import com.help.common.exception.UnifyErrorCode;
import com.help.common.exception.UnifyException;
import com.help.common.util.Compare;
import com.help.constraint.IHelpSystemComponent;
import com.helpframework.storage.ITokenStorege;
import javax.servlet.http.HttpSession;
import org.springframework.beans.factory.annotation.Autowired;

public class HttpSessionTokenStorage<T extends AbstractLoginToken>
implements ITokenStorege<T>,
IHelpSystemComponent {
    @Autowired
    HttpSession session;
    private static final String LOGIN_INFO_SESSION_KEY = "session_id_loginInfo";

    public String getName() {
        return "Token\u4fdd\u6301\u670d\u52a1-SESSION";
    }

    public void save(T token, long expireMs) {
        this.session.setMaxInactiveInterval((int)(expireMs / 1000L));
        this.session.setAttribute(LOGIN_INFO_SESSION_KEY, token);
    }

    public void delete(String key) {
        AbstractLoginToken token = (AbstractLoginToken)this.session.getAttribute(LOGIN_INFO_SESSION_KEY);
        if (token != null && Compare.equals((String)token.getToken(), (String)key)) {
            this.session.removeAttribute(LOGIN_INFO_SESSION_KEY);
        } else if (token != null) {
            throw new UnifyException(UnifyErrorCode.UNKNOW_FAIL, "\u4e0d\u5141\u8bb8\u64cd\u4f5c\u5176\u4ed6\u7528\u6237\u7684Token");
        }
    }

    public T get(String key) {
        AbstractLoginToken token = (AbstractLoginToken)this.session.getAttribute(LOGIN_INFO_SESSION_KEY);
        if (token != null && !Compare.equals((String)token.getToken(), (String)key)) {
            return null;
        }
        return (T)token;
    }

    public void refresh(String key, long expireMs) {
    }
}

