/*
 * Decompiled with CFR 0.152.
 */
package com.helpframework.autoconfig;

import com.help.HelpTokenConfig;
import com.help.ITokenContext;
import com.help.common.util.StringUtil;
import com.helpframework.HelpTokenContext;
import com.helpframework.HelpTokenContextRequestScope;
import com.helpframework.aop.TokenRefreshAspect;
import com.helpframework.autoconfig.DefaultTokenStorageAutoConfiguration;
import com.helpframework.autoconfig.HelpTokenConfigAutoConfiguration;
import com.helpframework.filter.HelpTokenMDCFilter;
import com.helpframework.storage.ITokenStorege;
import javax.servlet.Filter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Scope;
import org.springframework.context.annotation.ScopedProxyMode;

@AutoConfigureAfter(value={DefaultTokenStorageAutoConfiguration.class, HelpTokenConfigAutoConfiguration.class})
public class HelpTokenAutoConfiguration {
    Logger logger = LoggerFactory.getLogger(HelpTokenAutoConfiguration.class);

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnBean(value={ITokenStorege.class})
    @Scope(value="request", proxyMode=ScopedProxyMode.TARGET_CLASS)
    public HelpTokenContextRequestScope helpTokenContextRequestScope(ITokenStorege iTokenStorege) {
        return new HelpTokenContextRequestScope(iTokenStorege);
    }

    @Bean
    @ConditionalOnMissingBean(value={ITokenContext.class})
    @ConditionalOnBean(value={HelpTokenConfig.class, HelpTokenContextRequestScope.class})
    public HelpTokenContext helpTokenContext(HelpTokenContextRequestScope requestScope) {
        return new HelpTokenContext(requestScope);
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnBean(value={HelpTokenConfig.class, HelpTokenContext.class})
    public TokenRefreshAspect tokenRefreshAspect(HelpTokenConfig config) {
        this.logger.info("\u68c0\u6d4b\u5230Token\u6a21\u5757,\u81ea\u52a8\u914d\u7f6e[HELP-Token\u7ba1\u7406\u5668],Token\u6765\u6e90[" + StringUtil.join((Object[])config.getTokenMode(), (String)",") + "],\u6620\u5c04\u8bf7\u6c42\u53c2\u6570[" + config.getField() + "],\u8d85\u65f6\u65f6\u95f4[" + config.getInvalidTime() + "ms]");
        return new TokenRefreshAspect();
    }

    @Bean
    @ConditionalOnBean(value={HelpTokenConfig.class})
    @ConditionalOnMissingBean(value={HelpTokenMDCFilter.class}, parameterizedContainer={FilterRegistrationBean.class})
    public FilterRegistrationBean<HelpTokenMDCFilter> helpTokenMDCFilterFilterRegistrationBean(ITokenContext iTokenContext) {
        FilterRegistrationBean registration = new FilterRegistrationBean();
        registration.setFilter((Filter)new HelpTokenMDCFilter(iTokenContext));
        registration.addUrlPatterns(new String[]{"/*"});
        registration.setName("helpTokenMDCFilter");
        registration.setOrder(2);
        return registration;
    }
}

