/*
 * Decompiled with CFR 0.152.
 */
package com.helpframework;

import com.help.AbstractLoginToken;
import com.help.HelpTokenConfig;
import com.help.TokenMode;
import com.help.common.util.StringUtil;
import com.helpframework.storage.ITokenStorege;
import java.util.Date;
import java.util.UUID;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;

public class HelpTokenContextRequestScope<T extends AbstractLoginToken> {
    @Autowired
    HttpServletRequest httpServletRequest;
    @Autowired
    HttpServletResponse httpServletResponse;
    @Autowired
    HelpTokenConfig config;
    T token;
    boolean loaded;
    private ITokenStorege<T> iTokenStorege;

    public HelpTokenContextRequestScope(ITokenStorege iTokenStorege) {
        this.iTokenStorege = iTokenStorege;
    }

    public void saveToken(T token) {
        if (StringUtil.isEmpty((String)token.getToken())) {
            token.setToken(UUID.randomUUID().toString());
        }
        if (token.getLoginTime() == null) {
            token.setLoginTime(new Date());
        }
        this.iTokenStorege.save(token, this.config.getInvalidTime());
        this.token = token;
        this.loaded = true;
        if (this.config.getTokenMode() != null) {
            for (TokenMode mode : this.config.getTokenMode()) {
                if (mode != TokenMode.COOKIE || this.httpServletResponse == null) continue;
                Cookie cookie = new Cookie(this.config.getField(), token.getToken());
                cookie.setPath("/");
                cookie.setHttpOnly(this.config.isHttpOnly());
                this.httpServletResponse.addCookie(cookie);
                break;
            }
        }
    }

    public void refresh() {
        String tk = this.getCurrentTokenKey();
        if (StringUtil.isNotEmpty((String)tk)) {
            this.iTokenStorege.refresh(tk, this.config.getInvalidTime());
        }
    }

    public void removeToken() {
        String tk = this.getCurrentTokenKey();
        if (StringUtil.isNotEmpty((String)tk)) {
            this.iTokenStorege.delete(tk);
        }
        this.token = null;
        this.loaded = true;
    }

    public T getCurrentToken() {
        if (this.token != null) {
            return this.token;
        }
        if (!this.loaded) {
            String tk = this.getCurrentTokenKey();
            if (StringUtil.isNotEmpty((String)tk)) {
                this.token = this.iTokenStorege.get(tk);
                this.loaded = true;
                return this.token;
            }
            this.loaded = true;
            return null;
        }
        return null;
    }

    public T getToken(String token) {
        return (T)this.iTokenStorege.get(token);
    }

    public String getCurrentTokenKey() {
        String tokenKey = null;
        if (this.config.getTokenMode() != null && this.httpServletRequest != null) {
            for (TokenMode mode : this.config.getTokenMode()) {
                Cookie[] cookies;
                if (mode == TokenMode.HEADER) {
                    tokenKey = this.httpServletRequest.getHeader(this.config.getField());
                } else if (mode == TokenMode.PARAM) {
                    tokenKey = this.httpServletRequest.getParameter(this.config.getField());
                } else if (mode == TokenMode.COOKIE && (cookies = this.httpServletRequest.getCookies()) != null && cookies.length > 0) {
                    for (Cookie ck : cookies) {
                        if (!ck.getName().equals(this.config.getField())) continue;
                        return ck.getValue();
                    }
                }
                if (!StringUtil.isNotEmpty((String)tokenKey)) continue;
                return tokenKey;
            }
        }
        return tokenKey;
    }
}

