/*
 * Decompiled with CFR 0.152.
 */
package com.helpframework;

import com.help.AbstractLoginToken;
import com.help.ITokenContext;
import com.helpframework.HelpTokenContextRequestScope;
import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanCreationException;

public class HelpTokenContext<T extends AbstractLoginToken>
implements ITokenContext<T>,
Serializable {
    Logger logger = LoggerFactory.getLogger(HelpTokenContext.class);
    HelpTokenContextRequestScope<T> requestScope;

    public HelpTokenContext(HelpTokenContextRequestScope requestScope) {
        this.requestScope = requestScope;
    }

    public void saveToken(T token) {
        try {
            this.requestScope.saveToken(token);
        }
        catch (BeanCreationException exception) {
            this.logger.debug("\u672a\u83b7\u53d6\u5230\u8bf7\u6c42\u4fe1\u606f", (Throwable)exception);
        }
    }

    public void refresh() {
        try {
            this.requestScope.refresh();
        }
        catch (BeanCreationException exception) {
            this.logger.debug("\u672a\u83b7\u53d6\u5230\u8bf7\u6c42\u4fe1\u606f", (Throwable)exception);
        }
    }

    public void removeToken() {
        try {
            this.requestScope.removeToken();
        }
        catch (BeanCreationException exception) {
            this.logger.debug("\u672a\u83b7\u53d6\u5230\u8bf7\u6c42\u4fe1\u606f", (Throwable)exception);
        }
    }

    public T getCurrentToken() {
        try {
            return this.requestScope.getCurrentToken();
        }
        catch (BeanCreationException exception) {
            this.logger.debug("\u672a\u83b7\u53d6\u5230\u8bf7\u6c42\u4fe1\u606f", (Throwable)exception);
            return null;
        }
    }

    public T getToken(String token) {
        try {
            return this.requestScope.getToken(token);
        }
        catch (BeanCreationException exception) {
            this.logger.debug("\u672a\u83b7\u53d6\u5230\u8bf7\u6c42\u4fe1\u606f", (Throwable)exception);
            return null;
        }
    }

    public String getCurrentTokenKey() {
        try {
            return this.requestScope.getCurrentTokenKey();
        }
        catch (BeanCreationException exception) {
            this.logger.debug("\u672a\u83b7\u53d6\u5230\u8bf7\u6c42\u4fe1\u606f", (Throwable)exception);
            return null;
        }
    }
}

