/*
 * Decompiled with CFR 0.152.
 */
package com.helpframework.controller;

import com.help.annotation.UnifyAuthorization;
import com.help.common.InvocationResult;
import com.help.common.UnifyPageData;
import com.help.common.UnifyPageInfo;
import com.help.common.annotation.ParamValid;
import com.help.domain.LegalInfo;
import com.help.storage.ILegalStorage;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/legal"})
@UnifyAuthorization(module="config_legal", moduleName="\u6cd5\u4eba\u7ba1\u7406", system="1")
public class LegalController {
    @Autowired
    private ILegalStorage iLegalStorage;

    @PostMapping(value={"/detail.do"})
    @UnifyAuthorization(op="detail")
    public InvocationResult<LegalInfo> detail(@ParamValid String legalNo) {
        return new InvocationResult((Object)this.iLegalStorage.get(legalNo));
    }

    @RequestMapping(value={"/list.do"}, method={RequestMethod.POST})
    public InvocationResult<List<LegalInfo>> list() {
        return new InvocationResult((Object)this.iLegalStorage.list());
    }

    @UnifyAuthorization(op="visit")
    @PostMapping(value={"/listByPage.do"})
    public InvocationResult<UnifyPageData<LegalInfo>> listByPage(UnifyPageInfo page, @RequestParam(required=false) String name) {
        UnifyPageData list = this.iLegalStorage.searchByPage(name, page);
        return new InvocationResult((Object)list);
    }
}

