/*
 * Decompiled with CFR 0.152.
 */
package com.helpframework.controller;

import com.help.ITokenContext;
import com.help.LoginInfo;
import com.help.annotation.OperationLog;
import com.help.annotation.UnifyAuthorization;
import com.help.common.InvocationResult;
import com.help.common.annotation.ParamValid;
import com.help.common.exception.UnifyErrorCode;
import com.help.constant.OperationType;
import com.help.domain.UserInfo;
import com.help.storage.editable.IEditableUserStorage;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@UnifyAuthorization(module="config_user", moduleName="\u7528\u6237\u7ba1\u7406", system="1")
@RestController
@RequestMapping(value={"/user"})
public class EditUserController {
    @Autowired
    private IEditableUserStorage iUserStorage;
    @Autowired
    ITokenContext<LoginInfo> iTokenContext;

    @PostMapping(value={"/create.do"})
    @UnifyAuthorization(op="add")
    @OperationLog(value="\u65b0\u589e\u7528\u6237[{0}-{1}]", spel={"#user.userNo", "#user.userName"}, type=OperationType.BASE)
    public InvocationResult create(@ParamValid UserInfo user) {
        user.setCreateTime(new Date(System.currentTimeMillis()));
        user.setCreater(((LoginInfo)this.iTokenContext.getCurrentToken()).getUserId());
        user.setPassword("123456");
        this.iUserStorage.add(user);
        return new InvocationResult((Object)"123456");
    }

    @PostMapping(value={"/update.do"})
    @UnifyAuthorization(op="update")
    @OperationLog(value="\u4fee\u6539\u7528\u6237[{0}]", spel={"#user.userNo"}, type=OperationType.BASE)
    public InvocationResult update(@ParamValid UserInfo user) {
        this.iUserStorage.edit(user);
        return InvocationResult.SUCCESS;
    }

    @PostMapping(value={"/reset.do"})
    @UnifyAuthorization(op="reset", opName="\u91cd\u8bbe\u5bc6\u7801")
    @OperationLog(value="\u91cd\u7f6e\u7528\u6237[{0}]\u5bc6\u7801", spel={"#userNo"}, type=OperationType.BASE)
    public InvocationResult reset(@ParamValid String userNo) {
        this.iUserStorage.resetPwd(userNo, "123456");
        return new InvocationResult((Object)"123456");
    }

    @PostMapping(value={"/delete.do"})
    @UnifyAuthorization(op="delete")
    @OperationLog(value="\u5220\u9664\u7528\u6237[{0}]", spel={"#userNo"}, type=OperationType.BASE)
    public InvocationResult delete(@ParamValid String userNo) {
        if (((LoginInfo)this.iTokenContext.getCurrentToken()).getUserId().equalsIgnoreCase(userNo)) {
            return new InvocationResult(UnifyErrorCode.BUSINESS_FAILD, "\u60a8\u4e0d\u53ef\u4ee5\u5220\u9664\u81ea\u5df1");
        }
        this.iUserStorage.delete(userNo);
        return InvocationResult.SUCCESS;
    }
}

