/*
 * Decompiled with CFR 0.152.
 */
package com.helpframework.controller;

import com.help.ITokenContext;
import com.help.LoginInfo;
import com.help.annotation.OperationLog;
import com.help.annotation.UnifyAuthorization;
import com.help.common.InvocationResult;
import com.help.common.util.StringUtil;
import com.help.constant.OperationType;
import com.help.storage.editable.IEditableUserAffiliationStorage;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@UnifyAuthorization(module="config_user", moduleName="\u7528\u6237\u7ba1\u7406", system="1")
@RestController
@RequestMapping(value={"/user"})
public class EditUserAffiliationController {
    @Autowired
    private IEditableUserAffiliationStorage iEditableUserAffiliationStorage;
    @Autowired
    ITokenContext<LoginInfo> iTokenContext;

    @Transactional
    @UnifyAuthorization(op="update_role", opName="\u5206\u914d\u89d2\u8272")
    @PostMapping(value={"/joinToRole.do"})
    @OperationLog(value="\u4e3a\u7528\u6237[{0}]\u5206\u914d\u89d2\u8272[{1}]", spel={"#userNo", "#roleNo"}, type=OperationType.BASE)
    public InvocationResult joinToRole(String userNo, String[] roleNo, @RequestParam(required=false) String deptNo, @RequestParam(required=false) String orgNo) {
        for (String r : roleNo) {
            if (StringUtil.isEmpty((String)deptNo) && StringUtil.isEmpty((String)orgNo)) {
                this.iEditableUserAffiliationStorage.addUserToRole(userNo, r);
                continue;
            }
            if (StringUtil.isNotEmpty((String)deptNo)) {
                this.iEditableUserAffiliationStorage.addUserToDeptRole(userNo, deptNo, r);
            }
            if (!StringUtil.isNotEmpty((String)orgNo)) continue;
            this.iEditableUserAffiliationStorage.addUserToOrgRole(userNo, orgNo, r);
        }
        return InvocationResult.SUCCESS;
    }

    @UnifyAuthorization(op="update_role", opName="\u7528\u6237\u89d2\u8272\u914d\u7f6e")
    @PostMapping(value={"/leaveFromRole.do"})
    @OperationLog(value="\u79fb\u9664\u7528\u6237[{0}]\u7684\u89d2\u8272[{1}]", spel={"#userNo", "#roleNo"}, type=OperationType.BASE)
    public InvocationResult leaveFromDept(String userNo, String roleNo, @RequestParam(required=false) String deptNo, @RequestParam(required=false) String orgNo) {
        if (StringUtil.isEmpty((String)deptNo) && StringUtil.isEmpty((String)orgNo)) {
            this.iEditableUserAffiliationStorage.removeUserFromRole(userNo, roleNo);
        } else {
            if (StringUtil.isNotEmpty((String)deptNo)) {
                this.iEditableUserAffiliationStorage.removeUserFromDeptRole(userNo, deptNo, roleNo);
            }
            if (StringUtil.isNotEmpty((String)orgNo)) {
                this.iEditableUserAffiliationStorage.removeUserFromOrgRole(userNo, orgNo, roleNo);
            }
        }
        return InvocationResult.SUCCESS;
    }
}

