/*
 * Decompiled with CFR 0.152.
 */
package com.helpframework.controller;

import com.help.annotation.OperationLog;
import com.help.annotation.UnifyAuthorization;
import com.help.common.InvocationResult;
import com.help.common.annotation.ParamValid;
import com.help.constant.OperationType;
import com.help.domain.TreeDicItem;
import com.help.storage.editable.IEditableTreeDicStorage;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@UnifyAuthorization(module="config_treedic", moduleName="\u6811\u5f62\u5b57\u5178\u914d\u7f6e", system="1")
@RequestMapping(value={"/treedic"})
public class EditTreeDicController {
    @Autowired
    private IEditableTreeDicStorage iTreeDicStorage;

    @UnifyAuthorization(op="add")
    @PostMapping(value={"/create.do"})
    @OperationLog(value="\u521b\u5efa\u6811\u5f62\u5b57\u5178[{0}-{1}-{2}]", spel={"dic.dicType", "#dic.code", "#dic.text"}, type=OperationType.BASE)
    public InvocationResult create(@ParamValid TreeDicItem dic) {
        this.iTreeDicStorage.add(dic);
        return InvocationResult.SUCCESS;
    }

    @UnifyAuthorization(op="update")
    @PostMapping(value={"/update.do"})
    @OperationLog(value="\u4fee\u6539\u6811\u5f62\u5b57\u5178[{0}-{1}]", spel={"#dic.dicType", "#dic.code"}, type=OperationType.BASE)
    public InvocationResult update(@ParamValid TreeDicItem dic) {
        this.iTreeDicStorage.edit(dic);
        return new InvocationResult((Object)dic);
    }

    @UnifyAuthorization(op="delete")
    @PostMapping(value={"/delete.do"})
    @OperationLog(value="\u5220\u9664\u6811\u5f62\u5b57\u5178[{0}-{1}]", spel={"#dicType", "#code"}, type=OperationType.BASE)
    public InvocationResult delete(@ParamValid String dicType, @ParamValid String code) {
        this.iTreeDicStorage.deleteAll(dicType, code);
        return InvocationResult.SUCCESS;
    }
}

