/*
 * Decompiled with CFR 0.152.
 */
package com.helpframework.controller;

import com.help.annotation.OperationLog;
import com.help.annotation.UnifyAuthorization;
import com.help.common.InvocationResult;
import com.help.common.annotation.ParamValid;
import com.help.common.exception.UnifyErrorCode;
import com.help.common.exception.UnifyException;
import com.help.common.exception.UnifyValidateException;
import com.help.common.util.StringUtil;
import com.help.constant.OperationType;
import com.help.domain.RoleInfo;
import com.help.service.UnionService;
import com.help.storage.editable.IEditableRoleStorage;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/role"})
@UnifyAuthorization(module="config_role", moduleName="\u89d2\u8272\u7ba1\u7406", system="1")
public class EditRoleController {
    @Autowired
    private IEditableRoleStorage roleService;
    @Autowired
    private UnionService unionService;

    @UnifyAuthorization(op="add")
    @PostMapping(value={"/create.do"})
    @OperationLog(value="\u521b\u5efa\u89d2\u8272[{0}-{1}]", spel={"#role.roleNo", "#role.roleName"}, type=OperationType.SYSTEM)
    public InvocationResult create(@ParamValid RoleInfo role) {
        role.setState("1");
        this.roleService.add(role);
        return InvocationResult.SUCCESS;
    }

    @UnifyAuthorization(op="update")
    @PostMapping(value={"/update.do"})
    @OperationLog(value="\u4fee\u6539\u89d2\u8272[{0}]", spel={"#role.roleNo"}, type=OperationType.SYSTEM)
    public InvocationResult update(@ParamValid RoleInfo role) {
        if (StringUtil.isNotEmpty((String)role.getRoleNo())) {
            role.setState("1");
            if ("admin".equalsIgnoreCase(role.getRoleNo()) && !"1".equalsIgnoreCase(role.getState())) {
                throw new UnifyException(UnifyErrorCode.BUSINESS_FAILD, "\u4e0d\u5141\u8bb8\u7981\u7528\u7ba1\u7406\u5458[admin]\u89d2\u8272");
            }
            if ("default".equalsIgnoreCase(role.getRoleNo()) && !"1".equalsIgnoreCase(role.getState())) {
                throw new UnifyException(UnifyErrorCode.BUSINESS_FAILD, "\u4e0d\u5141\u8bb8\u7981\u7528\u9ed8\u8ba4\u89d2\u8272[default]\u89d2\u8272");
            }
        } else {
            throw new UnifyValidateException("\u8bf7\u6c42\u53c2\u6570\u4e0d\u5408\u6cd5,\u7f3a\u5c11\u66f4\u65b0\u6761\u4ef6");
        }
        this.roleService.edit(role);
        return InvocationResult.SUCCESS;
    }

    @UnifyAuthorization(op="delete")
    @PostMapping(value={"/delete.do"})
    @OperationLog(value="\u5220\u9664\u89d2\u8272[{0}]", spel={"#role.roleNo"}, type=OperationType.SYSTEM)
    public InvocationResult delete(@ParamValid String roleNo) {
        if ("admin".equalsIgnoreCase(roleNo)) {
            throw new UnifyException(UnifyErrorCode.BUSINESS_FAILD, "\u4e0d\u5141\u8bb8\u5220\u9664\u7ba1\u7406\u5458[admin]\u89d2\u8272");
        }
        if ("default".equalsIgnoreCase(roleNo)) {
            throw new UnifyException(UnifyErrorCode.BUSINESS_FAILD, "\u4e0d\u5141\u8bb8\u5220\u9664\u9ed8\u8ba4\u89d2\u8272[default]\u89d2\u8272");
        }
        this.unionService.deleteRole(roleNo);
        return InvocationResult.SUCCESS;
    }
}

