/*
 * Decompiled with CFR 0.152.
 */
package com.helpframework.controller;

import com.help.ITokenContext;
import com.help.LoginInfo;
import com.help.annotation.OperationLog;
import com.help.annotation.UnifyAuthorization;
import com.help.common.HelpManageUtil;
import com.help.common.InvocationResult;
import com.help.common.annotation.ParamValid;
import com.help.common.exception.UnifyErrorCode;
import com.help.config.HelpManageConfig;
import com.help.constant.OperationType;
import com.help.service.UserConfigService;
import com.help.storage.editable.IEditableUserStorage;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class EditPasswordController {
    @Autowired
    private HelpManageConfig helpManageConfig;
    @Autowired
    IEditableUserStorage iUserStorage;
    @Autowired
    ITokenContext<LoginInfo> iTokenContext;
    @Autowired
    private UserConfigService pUserConfigService;

    @ResponseBody
    @PostMapping(value={"/editPassword.do"})
    @OperationLog(value="\u4fee\u6539\u767b\u5f55\u5bc6\u7801", type=OperationType.BASE)
    @UnifyAuthorization(module="personal_center", moduleName="\u4e2a\u4eba\u4e2d\u5fc3", op="edit_password", opName="\u4fee\u6539\u5bc6\u7801", grantToAll=true)
    public InvocationResult editPassword(@ParamValid String oldPwd, @ParamValid String newPwd) {
        String userNo;
        boolean succ;
        if (this.helpManageConfig.isStrongCipher()) {
            if (!HelpManageUtil.strongCipherValid(newPwd)) {
                return new InvocationResult(UnifyErrorCode.VALIDATE_FAILD, "\u65b0\u5bc6\u7801\u957f\u5ea6\u4e0d\u5f97\u5c11\u4e8e8\u4f4d,\u4e14\u5305\u542b\u6570\u5b57,\u5927\u5199\u5b57\u6bcd,\u5c0f\u5199\u5b57\u6bcd,\u7279\u6b8a\u7b26\u53f7\u4e2d\u7684\u4e09\u79cd\u53ca\u4ee5\u4e0a");
            }
        } else if (newPwd.length() < 6) {
            return new InvocationResult(UnifyErrorCode.VALIDATE_FAILD, "\u5bc6\u7801\u957f\u5ea6\u5fc5\u987b\u8d85\u8fc76\u4f4d");
        }
        if (succ = this.iUserStorage.resetPwd(userNo = ((LoginInfo)this.iTokenContext.getCurrentToken()).getUserId(), oldPwd, newPwd)) {
            if (this.helpManageConfig.isStrongCipher()) {
                this.pUserConfigService.delete(userNo, "WEAK_PASSWORD");
            }
            return InvocationResult.SUCCESS;
        }
        return new InvocationResult(UnifyErrorCode.BUSINESS_FAILD, "\u539f\u5bc6\u7801\u8f93\u5165\u9519\u8bef");
    }
}

