/*
 * Decompiled with CFR 0.152.
 */
package com.helpframework.controller;

import com.help.annotation.OperationLog;
import com.help.annotation.UnifyAuthorization;
import com.help.common.InvocationResult;
import com.help.common.annotation.ParamValid;
import com.help.common.util.StringUtil;
import com.help.constant.OperationType;
import com.help.domain.OrgInfoBase;
import com.help.storage.editable.IEditableOrgStorage;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@UnifyAuthorization(module="config_org", moduleName="\u673a\u6784\u7ba1\u7406", system="1")
@RequestMapping(value={"/org"})
public class EditOrgController {
    @Autowired
    private IEditableOrgStorage iOrgStorage;

    @UnifyAuthorization(op="add")
    @PostMapping(value={"/create.do"})
    @OperationLog(value="\u521b\u5efa\u673a\u6784[{0}-{1}]", spel={"#orgInfoBase.orgNo", "#orgInfoBase.orgName"}, type=OperationType.BASE)
    public InvocationResult create(@ParamValid OrgInfoBase orgInfoBase) {
        IEditableOrgStorage iEditableOrgService = this.iOrgStorage;
        if (StringUtil.isEmpty((String)orgInfoBase.getParentNo())) {
            orgInfoBase.setParentNo(null);
        }
        iEditableOrgService.add(orgInfoBase);
        return InvocationResult.SUCCESS;
    }

    @UnifyAuthorization(op="update")
    @PostMapping(value={"/update.do"})
    @OperationLog(value="\u4fee\u6539\u673a\u6784[{0}-{1}]", spel={"#orgInfoBase.orgNo", "#orgInfoBase.orgName"}, type=OperationType.BASE)
    public InvocationResult update(@ParamValid OrgInfoBase orgInfoBase) {
        IEditableOrgStorage iEditableOrgService = this.iOrgStorage;
        if (StringUtil.isEmpty((String)orgInfoBase.getParentNo())) {
            orgInfoBase.setParentNo(null);
        }
        iEditableOrgService.edit(orgInfoBase);
        return InvocationResult.SUCCESS;
    }

    @UnifyAuthorization(op="delete")
    @PostMapping(value={"/delete.do"})
    @OperationLog(value="\u5220\u9664\u673a\u6784[{0}]", spel={"#orgNo"}, type=OperationType.BASE)
    public InvocationResult delete(@ParamValid String orgNo) {
        this.iOrgStorage.delete(orgNo);
        return InvocationResult.SUCCESS;
    }

    @UnifyAuthorization(op="delete")
    @PostMapping(value={"/deleteDeep.do"})
    @OperationLog(value="\u5220\u9664\u673a\u6784\u53ca\u5b50\u96c6[{0}]", spel={"#orgNo"}, type=OperationType.BASE)
    public InvocationResult deleteDeep(@ParamValid String orgNo) {
        this.iOrgStorage.deleteWithAll(orgNo);
        return InvocationResult.SUCCESS;
    }
}

