/*
 * Decompiled with CFR 0.152.
 */
package com.helpframework.controller;

import com.help.annotation.OperationLog;
import com.help.annotation.UnifyAuthorization;
import com.help.common.InvocationResult;
import com.help.common.annotation.ParamValid;
import com.help.constant.OperationType;
import com.help.domain.LegalInfo;
import com.help.storage.editable.IEditableLegalStorage;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/legal"})
@UnifyAuthorization(module="config_legal", moduleName="\u6cd5\u4eba\u7ba1\u7406", system="1")
public class EditLegalController {
    @Autowired
    private IEditableLegalStorage iEditableLegalStorage;

    @UnifyAuthorization(op="add")
    @PostMapping(value={"/create.do"})
    @OperationLog(value="\u521b\u5efa\u6cd5\u4eba[{0}-{1}}]", spel={"#legalInfo.legalNo", "#legalInfo.legalName"}, type=OperationType.BASE)
    public InvocationResult create(@ParamValid LegalInfo legalInfo) {
        this.iEditableLegalStorage.add(legalInfo);
        return InvocationResult.SUCCESS;
    }

    @UnifyAuthorization(op="update")
    @PostMapping(value={"/update.do"})
    @OperationLog(value="\u4fee\u6539\u6cd5\u4eba[{0}]", spel={"#legalInfo.legalNo"}, type=OperationType.BASE)
    public InvocationResult update(@ParamValid LegalInfo legalInfo) {
        this.iEditableLegalStorage.edit(legalInfo);
        return InvocationResult.SUCCESS;
    }

    @UnifyAuthorization(op="delete")
    @PostMapping(value={"/delete.do"})
    @OperationLog(value="\u5220\u9664\u6cd5\u4eba[{0}]", spel={"#legalNo"}, type=OperationType.BASE)
    public InvocationResult delete(@ParamValid String legalNo) {
        this.iEditableLegalStorage.delete(legalNo);
        return InvocationResult.SUCCESS;
    }
}

