/*
 * Decompiled with CFR 0.152.
 */
package com.helpframework.controller;

import com.help.annotation.OperationLog;
import com.help.annotation.UnifyAuthorization;
import com.help.common.InvocationResult;
import com.help.common.annotation.ParamValid;
import com.help.constant.OperationType;
import com.help.domain.DicItem;
import com.help.storage.editable.IEditableDicStorage;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@UnifyAuthorization(module="config_dic", moduleName="\u5b57\u5178\u914d\u7f6e", system="1")
@RequestMapping(value={"/pDic"})
public class EditDicController {
    @Autowired
    private IEditableDicStorage iEditableDicStorage;

    @PostMapping(value={"/create.do"})
    @UnifyAuthorization(op="add")
    @OperationLog(value="\u521b\u5efa\u5b57\u5178[{0}-{1}-{2}]", spel={"#dic.dicType", "#dic.code", "#dic.text"}, type=OperationType.BASE)
    public InvocationResult create(@ParamValid DicItem dic) {
        this.iEditableDicStorage.add(dic);
        return InvocationResult.SUCCESS;
    }

    @PostMapping(value={"/update.do"})
    @UnifyAuthorization(op="update")
    @OperationLog(value="\u4fee\u6539\u5b57\u5178[{0}]", spel={"#dic.dicType", "#dic.code"}, type=OperationType.BASE)
    public InvocationResult update(@ParamValid DicItem dic) {
        this.iEditableDicStorage.edit(dic);
        return new InvocationResult((Object)dic);
    }

    @PostMapping(value={"/delete.do"})
    @UnifyAuthorization(op="delete")
    @OperationLog(value="\u5220\u9664\u5b57\u5178[{0}-{1}]", spel={"#dicType", "#code"}, type=OperationType.BASE)
    public InvocationResult delete(@ParamValid String dicType, @ParamValid String code) {
        this.iEditableDicStorage.delete(dicType, code);
        return InvocationResult.SUCCESS;
    }
}

