/*
 * Decompiled with CFR 0.152.
 */
package com.helpframework.controller;

import com.help.annotation.OperationLog;
import com.help.annotation.UnifyAuthorization;
import com.help.common.InvocationResult;
import com.help.common.annotation.ParamValid;
import com.help.common.exception.UnifyValidateException;
import com.help.common.util.StringUtil;
import com.help.constant.OperationType;
import com.help.domain.DeptInfo;
import com.help.storage.editable.IEditableDeptStorage;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/dept"})
@UnifyAuthorization(module="config_dept", moduleName="\u90e8\u95e8\u7ba1\u7406", system="1")
public class EditDeptController {
    @Autowired
    private IEditableDeptStorage deptService;

    @PostMapping(value={"/create.do"})
    @UnifyAuthorization(op="add")
    @OperationLog(value="\u521b\u5efa\u90e8\u95e8[{0}-{1}]", spel={"#dept.deptNo", "#dept.deptName"}, type=OperationType.BASE)
    public InvocationResult create(@ParamValid DeptInfo dept) {
        this.deptService.add(dept);
        return InvocationResult.SUCCESS;
    }

    @PostMapping(value={"/update.do"})
    @UnifyAuthorization(op="update")
    @OperationLog(value="\u4fee\u6539\u90e8\u95e8[{0}]", spel={"#dept.deptNo"}, type=OperationType.BASE)
    public InvocationResult update(@ParamValid DeptInfo dept) {
        if (!StringUtil.isNotEmpty((String)dept.getDeptNo())) {
            throw new UnifyValidateException("\u8bf7\u6c42\u53c2\u6570\u4e0d\u5408\u6cd5,\u7f3a\u5c11\u66f4\u65b0\u6761\u4ef6");
        }
        this.deptService.edit(dept);
        return InvocationResult.SUCCESS;
    }

    @PostMapping(value={"/delete.do"})
    @UnifyAuthorization(op="delete")
    @OperationLog(value="\u5220\u9664\u90e8\u95e8[{0}]", spel={"#deptNo"}, type=OperationType.BASE)
    public InvocationResult delete(@ParamValid String deptNo) {
        this.deptService.delete(deptNo);
        return InvocationResult.SUCCESS;
    }
}

