/*
 * Decompiled with CFR 0.152.
 */
package com.help.web.controller;

import com.help.annotation.OperationLog;
import com.help.annotation.UnifyAuthorization;
import com.help.common.ICacheable;
import com.help.common.InvocationResult;
import com.help.common.exception.UnifyErrorCode;
import com.help.common.util.StringUtil;
import com.help.constant.OperationType;
import com.help.constraint.IHelpSystemComponent;
import com.help.constraint.IHelpSystemServer;
import com.help.constraint.IHelpSystemSocketServer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@UnifyAuthorization(module="config_service", moduleName="\u7cfb\u7edf\u670d\u52a1\u7ba1\u7406", system="1")
@RequestMapping(value={"/systemServer"})
public class SystemServerController {
    @Autowired(required=false)
    private Map<String, IHelpSystemComponent> iUnifyComponents;

    @UnifyAuthorization(op="visit")
    @PostMapping(value={"/list.do"})
    public InvocationResult list(String serviceName) {
        ArrayList unifyList = new ArrayList();
        if (this.iUnifyComponents != null) {
            for (Map.Entry<String, IHelpSystemComponent> kv : this.iUnifyComponents.entrySet()) {
                IHelpSystemSocketServer unifySockey;
                IHelpSystemComponent iUnifyComponent = kv.getValue();
                if (StringUtil.isNotEmpty((String)serviceName) && kv.getKey().indexOf(serviceName) < 0 && iUnifyComponent.getName().indexOf(serviceName) < 0) break;
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("name", kv.getKey());
                map.put("serviceName", iUnifyComponent.getName());
                if (iUnifyComponent instanceof IHelpSystemSocketServer || iUnifyComponent instanceof IHelpSystemServer) {
                    map.put("serviceStatus", ((IHelpSystemServer)iUnifyComponent).isRunning());
                    map.put("type", "server");
                } else {
                    map.put("serviceStatus", true);
                    map.put("type", "component");
                }
                if (iUnifyComponent instanceof IHelpSystemSocketServer && (unifySockey = (IHelpSystemSocketServer)iUnifyComponent).isRunning()) {
                    map.put("port", unifySockey.getPort());
                }
                if (iUnifyComponent instanceof ICacheable) {
                    map.put("refreshable", true);
                } else {
                    map.put("refreshable", false);
                }
                unifyList.add(map);
            }
        }
        return new InvocationResult(unifyList);
    }

    @UnifyAuthorization(op="start", opName="\u542f\u52a8\u670d\u52a1")
    @PostMapping(value={"/start.do"})
    @OperationLog(value="\u542f\u52a8\u670d\u52a1[{0}]", spel={"#name"}, type=OperationType.SYSTEM)
    public InvocationResult start(String name) {
        IHelpSystemComponent iUnifyComponent = this.iUnifyComponents.get(name);
        if (iUnifyComponent instanceof IHelpSystemServer) {
            IHelpSystemServer iUnifyServer = (IHelpSystemServer)iUnifyComponent;
            if (iUnifyServer.isRunning()) {
                return new InvocationResult(UnifyErrorCode.UNKNOW_FAIL, "\u542f\u52a8\u5931\u8d25\uff0c\u670d\u52a1\u5df2\u5f00\u542f");
            }
            iUnifyServer.start();
            return InvocationResult.SUCCESS;
        }
        return new InvocationResult(UnifyErrorCode.UNKNOW_FAIL, "\u8be5\u670d\u52a1\u65e0\u6cd5\u624b\u52a8\u542f\u505c");
    }

    @UnifyAuthorization(op="stop", opName="\u5173\u95ed\u670d\u52a1")
    @PostMapping(value={"/stop.do"})
    @OperationLog(value="\u5173\u95ed\u670d\u52a1[{0}]", spel={"#name"}, type=OperationType.SYSTEM)
    public InvocationResult stop(String name) {
        IHelpSystemComponent iUnifyComponent = this.iUnifyComponents.get(name);
        if (iUnifyComponent instanceof IHelpSystemServer) {
            IHelpSystemServer iUnifyServer = (IHelpSystemServer)iUnifyComponent;
            if (iUnifyServer.isRunning()) {
                iUnifyServer.stop();
            }
            return InvocationResult.SUCCESS;
        }
        return new InvocationResult(UnifyErrorCode.UNKNOW_FAIL, "\u8be5\u670d\u52a1\u65e0\u6cd5\u624b\u52a8\u542f\u505c");
    }
}

