/*
 * Decompiled with CFR 0.152.
 */
package com.help.web.controller;

import com.help.AbstractLoginToken;
import com.help.ITokenContext;
import com.help.LoginInfo;
import com.help.annotation.OperationLog;
import com.help.annotation.UnifyAuthorization;
import com.help.common.HelpManageUtil;
import com.help.common.ICacheable;
import com.help.common.IParamReader;
import com.help.common.InvocationResult;
import com.help.common.annotation.ParamValid;
import com.help.common.exception.UnifyErrorCode;
import com.help.common.exception.UnifyException;
import com.help.common.tuple.Tuple2;
import com.help.common.util.BeanConvert;
import com.help.common.util.StringUtil;
import com.help.config.HelpManageConfig;
import com.help.constant.OperationType;
import com.help.constraint.IHelpOAuthClientProxy;
import com.help.domain.DeptInfo;
import com.help.domain.DicItem;
import com.help.domain.OrgInfoBase;
import com.help.domain.TreeDicItem;
import com.help.plugins.DeptDicExtension;
import com.help.plugins.OrgTreeDicExtension;
import com.help.service.DictionaryService;
import com.help.service.ILoginService;
import com.help.service.PermissionService;
import com.help.service.UserConfigService;
import com.help.service.ValidCodeService;
import com.help.storage.IRoleStorage;
import com.help.storage.IUserStorage;
import com.help.storage.editable.IEditableUserStorage;
import com.help.web.module.DicItemFormated;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.imageio.ImageIO;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CookieValue;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class SystemController {
    private static final Logger logger = LoggerFactory.getLogger(SystemController.class);
    private final String VALID_CODE_COOKIE_NAME = "valid-code-key";
    @Autowired(required=false)
    IHelpOAuthClientProxy ioAuthClient;
    @Autowired
    ITokenContext<LoginInfo> iTokenContext;
    @Autowired
    IUserStorage iUserStorage;
    @Autowired
    IRoleStorage iRoleStorage;
    @Autowired
    OrgTreeDicExtension orgTreeDicExtension;
    @Autowired
    DeptDicExtension deptDicExtension;
    @Autowired
    ValidCodeService validCodeService;
    @Autowired
    private UserConfigService pUserConfigService;
    @Autowired
    private PermissionService permissionService;
    @Autowired(required=false)
    private CacheManager cacheManager;
    @Autowired
    private DictionaryService dictionaryService;
    @Autowired
    private ILoginService iLoginService;
    @Autowired(required=false)
    private IParamReader iParamReader;
    @Autowired
    private HelpManageConfig helpManageConfig;

    @PostConstruct
    public void init() {
        if (this.cacheManager == null) {
            logger.warn("\u672a\u627e\u5230\u7f13\u5b58\u7ba1\u7406\u5668,\u7cfb\u7edf\u7f13\u5b58\u53ef\u80fd\u672a\u542f\u7528");
        }
    }

    @PostMapping(value={"/sysConfig.do"})
    public InvocationResult sysConfig() {
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("passwordEditable", this.iUserStorage instanceof IEditableUserStorage ? "1" : "0");
        config.put("asyncOrgTree", this.helpManageConfig.isAsyncOrgTree() ? "1" : "0");
        config.put("strongCipher", this.helpManageConfig.isStrongCipher() ? "1" : "0");
        config.put("loginValidCode", this.helpManageConfig.isLoginValidCode() ? "1" : "0");
        return new InvocationResult(config);
    }

    @GetMapping(value={"/validCode"}, produces={"image/jpeg"})
    public ResponseEntity<ByteArrayResource> validCode(HttpServletResponse response, @CookieValue(value="valid-code-key", required=false) String validKey, @RequestParam(value="rnd", required=false) String rnd) {
        this.validCodeService.removeKey(validKey);
        Tuple2<String, BufferedImage> validCode = HelpManageUtil.getValidCodeImage(6);
        byte[] data = null;
        try (ByteArrayOutputStream bio = new ByteArrayOutputStream();){
            ImageIO.write((RenderedImage)validCode.getT2(), "JPG", bio);
            data = bio.toByteArray();
        }
        catch (IOException e) {
            throw new UnifyException(UnifyErrorCode.UNKNOW_FAIL, "\u9a8c\u8bc1\u7801\u751f\u6210\u5931\u8d25");
        }
        String key = null;
        key = StringUtil.isNotEmpty((String)rnd) ? this.validCodeService.createKey((String)validCode.getT1(), rnd) : this.validCodeService.createKey((String)validCode.getT1());
        Cookie cookie = new Cookie("valid-code-key", key);
        cookie.setPath("/");
        cookie.setHttpOnly(true);
        response.addCookie(cookie);
        ResponseEntity responseEntity = new ResponseEntity((Object)new ByteArrayResource(data), HttpStatus.OK);
        return responseEntity;
    }

    @PostMapping(value={"/loginAsync.do"})
    @OperationLog(value="\u7528\u6237\u767b\u5f55", userSpel="#username", type=OperationType.BUSINESS)
    public InvocationResult loginAsync(@ParamValid String username, @ParamValid String password, String validCode, @CookieValue(value="valid-code-key", required=false) String validKey, @RequestParam(value="rnd", required=false) String rnd) {
        if (password.length() < 6 || password.length() > 16) {
            return new InvocationResult(UnifyErrorCode.VALIDATE_FAILD, "\u5bc6\u7801\u957f\u5ea6\u5fc5\u987b\u662f6-16\u4f4d");
        }
        if (this.helpManageConfig.isLoginValidCode()) {
            if (StringUtil.isEmpty((String)validKey)) {
                validKey = rnd;
            }
            if (StringUtil.isEmpty((String)validCode)) {
                return new InvocationResult(UnifyErrorCode.VALIDATE_FAILD, "\u9a8c\u8bc1\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtil.isEmpty((String)validKey)) {
                return new InvocationResult(UnifyErrorCode.VALIDATE_FAILD, "\u9a8c\u8bc1\u7801\u968f\u673aKey\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!this.validCodeService.valid(validKey, validCode)) {
                return new InvocationResult(UnifyErrorCode.VALIDATE_FAILD, "\u9a8c\u8bc1\u7801\u9519\u8bef");
            }
        }
        LoginInfo old = (LoginInfo)this.iTokenContext.getCurrentToken();
        LoginInfo loginInfo = this.iLoginService.getToken(username, password);
        if (this.helpManageConfig.isStrongCipher() && !HelpManageUtil.strongCipherValid(password)) {
            this.pUserConfigService.save(username, "WEAK_PASSWORD", "1");
        }
        if (old != null && old.getUserId().equalsIgnoreCase(loginInfo.getUserId())) {
            return new InvocationResult((Object)old.getToken());
        }
        if (old != null) {
            this.iTokenContext.removeToken();
        }
        this.iTokenContext.saveToken((AbstractLoginToken)loginInfo);
        return new InvocationResult((Object)loginInfo.getToken());
    }

    @PostMapping(value={"/logout.do"})
    public InvocationResult logout() {
        this.iTokenContext.removeToken();
        return InvocationResult.SUCCESS;
    }

    @UnifyAuthorization
    @PostMapping(value={"/userInfo.do"})
    public InvocationResult userInfo() {
        LoginInfo loginInfo = (LoginInfo)this.iTokenContext.getCurrentToken();
        Map info = BeanConvert.toMap((Object)loginInfo, (String[])new String[0]);
        info.put("orgs", this.permissionService.listOrgs(loginInfo.getUserId()));
        info.put("depts", this.permissionService.listDepts(loginInfo.getUserId()));
        info.put("affi", this.permissionService.listAffiliations(loginInfo.getUserId()));
        info.put("ops", this.permissionService.listModuleOps(loginInfo));
        info.put("passwordEditable", this.iUserStorage instanceof IEditableUserStorage ? "1" : "0");
        return new InvocationResult((Object)info);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @UnifyAuthorization
    @PostMapping(value={"/switchLoginOrg.do"})
    public InvocationResult switchLoginOrg(String orgNo, String deptNo) {
        LoginInfo loginInfo = (LoginInfo)this.iTokenContext.getCurrentToken();
        if (StringUtil.isNotEmpty((String)orgNo)) {
            List<OrgInfoBase> userOrgs = this.permissionService.listOrgs(loginInfo.getUserId());
            OrgInfoBase loginOrg = userOrgs.stream().filter(p -> p.getOrgNo().equalsIgnoreCase(orgNo)).findFirst().orElse(null);
            if (loginOrg == null) return new InvocationResult(UnifyErrorCode.BUSINESS_FAILD.getCode(), "\u673a\u6784\u5207\u6362\u5931\u8d25\uff0c\u5f53\u524d\u7528\u6237\u4e0d\u5c5e\u4e8e\u8be5\u673a\u6784");
            loginInfo.setLoginOrg(orgNo);
            this.pUserConfigService.save(loginInfo.getUserId(), "LAST_LOGIN_ORG", orgNo);
        } else {
            loginInfo.setLoginOrg(null);
            this.pUserConfigService.delete(loginInfo.getUserId(), "LAST_LOGIN_ORG");
        }
        if (StringUtil.isNotEmpty((String)deptNo)) {
            List<DeptInfo> userDept = this.permissionService.listDepts(loginInfo.getUserId());
            DeptInfo loginDept = userDept.stream().filter(p -> p.getDeptNo().equalsIgnoreCase(deptNo)).findFirst().orElse(null);
            if (loginDept == null) return new InvocationResult(UnifyErrorCode.BUSINESS_FAILD.getCode(), "\u673a\u6784\u5207\u6362\u5931\u8d25\uff0c\u5f53\u524d\u7528\u6237\u4e0d\u5c5e\u4e8e\u8be5\u673a\u6784");
            loginInfo.setLoginDept(deptNo);
            this.pUserConfigService.save(loginInfo.getUserId(), "LAST_LOGIN_DEPT", deptNo);
        } else {
            loginInfo.setLoginDept(null);
            this.pUserConfigService.delete(loginInfo.getUserId(), "LAST_LOGIN_DEPT");
        }
        List roles = this.permissionService.listRoles(loginInfo.getUserId(), loginInfo.getLoginOrg(), loginInfo.getLoginDept(), false).stream().map(p -> p.getRoleNo()).collect(Collectors.toList());
        loginInfo.setLoginRoles(roles);
        this.iTokenContext.saveToken((AbstractLoginToken)loginInfo);
        return InvocationResult.SUCCESS;
    }

    private List<Map<String, Object>> fillChild(List<TreeDicItem> all) {
        List list = all.stream().map(p -> {
            HashMap<String, Object> item = new HashMap<String, Object>();
            item.put("code", p.getCode());
            item.put("text", p.getText());
            item.put("child", new ArrayList());
            item.put("parent", p.getParent());
            return item;
        }).collect(Collectors.toList());
        for (Map item : list) {
            Map parent = list.stream().filter(p -> p.get("code").toString().equals(item.get("parent"))).findAny().orElse(null);
            if (parent != null) {
                ((List)parent.get("child")).add(item);
                continue;
            }
            item.remove("parent");
        }
        return list.stream().filter(p -> StringUtil.isEmpty(p.get("parent"))).collect(Collectors.toList());
    }

    @UnifyAuthorization
    @PostMapping(value={"/listDicFormat.do"})
    public InvocationResult listDicFormat(@ParamValid String[] dicType) {
        HashMap<String, List<Object>> dics = new HashMap<String, List<Object>>();
        for (String t : dicType) {
            List<DicItem> list = this.dictionaryService.list(t);
            if (list != null && list.size() > 0) {
                dics.put(t, list.stream().map(p -> new DicItemFormated((DicItem)p)).collect(Collectors.toList()));
                continue;
            }
            dics.put(t, this.fillChild(this.dictionaryService.listTree(t)));
        }
        return new InvocationResult(dics);
    }

    @UnifyAuthorization
    @PostMapping(value={"/listDic.do"})
    public InvocationResult listDic(@ParamValid String[] dicType) {
        HashMap<String, List<Object>> dics = new HashMap<String, List<Object>>();
        for (String t : dicType) {
            List<DicItem> list = this.dictionaryService.list(t);
            if (list != null && list.size() > 0) {
                dics.put(t, list);
                continue;
            }
            dics.put(t, this.dictionaryService.listTree(t));
        }
        return new InvocationResult(dics);
    }

    @UnifyAuthorization
    @PostMapping(value={"/listTreeDic.do"})
    public InvocationResult listTreeDic(@ParamValid String[] dicType) {
        HashMap<String, List<TreeDicItem>> dics = new HashMap<String, List<TreeDicItem>>();
        for (String t : dicType) {
            dics.put(t, this.dictionaryService.listTree(t));
        }
        return new InvocationResult(dics);
    }

    @UnifyAuthorization
    @PostMapping(value={"/listDeptDicFormatByLegal.do"})
    public InvocationResult listDeptDicFormatByLegal(@RequestParam(value="legal", required=false) String legal) {
        List list = this.deptDicExtension.listByLegal(legal, true).stream().map(p -> new DicItemFormated((DicItem)p)).collect(Collectors.toList());
        return new InvocationResult(list);
    }

    @UnifyAuthorization
    @PostMapping(value={"/listOrgDicFormatByLegal.do"})
    public InvocationResult listOrgDicFormatByLegal(@RequestParam(value="legal", required=false) String legal) {
        List<TreeDicItem> list = this.orgTreeDicExtension.listByLegal(legal, true);
        return new InvocationResult(this.fillChild(list));
    }

    @UnifyAuthorization(module="config_cache", moduleName="\u7f13\u5b58\u6e05\u7406", op="clean", opName="\u6e05\u7a7a\u7f13\u5b58", system="1")
    @PostMapping(value={"/cleanCache.do"})
    @OperationLog(value="\u6e05\u7a7a\u7f13\u5b58", type=OperationType.SYSTEM)
    public InvocationResult cleanCache(String name) {
        if (this.cacheManager != null) {
            if (StringUtil.isEmpty((String)name)) {
                if (this.iParamReader != null && this.iParamReader instanceof ICacheable) {
                    ((ICacheable)this.iParamReader).refresh();
                }
                for (String c : this.cacheManager.getCacheNames()) {
                    Cache cache = this.cacheManager.getCache(c);
                    if (cache == null) continue;
                    cache.clear();
                }
                return InvocationResult.SUCCESS;
            }
            if (!"session".equals(name)) {
                Cache cache = this.cacheManager.getCache(name);
                if (cache != null) {
                    cache.clear();
                    return InvocationResult.SUCCESS;
                }
                throw new UnifyException(UnifyErrorCode.VALIDATE_FAILD.getCode(), "\u7f13\u5b58\u4e0d\u5b58\u5728");
            }
            return new InvocationResult(UnifyErrorCode.NON_INTERFACE, "\u5f53\u524d\u7cfb\u7edf\u914d\u7f6e\u4e0d\u652f\u6301\u6b64\u64cd\u4f5c");
        }
        return new InvocationResult(UnifyErrorCode.BUSINESS_FAILD, "\u7cfb\u7edf\u7f13\u5b58\u672a\u542f\u7528");
    }
}

