/*
 * Decompiled with CFR 0.152.
 */
package com.help.web.controller;

import com.help.annotation.UnifyAuthorization;
import com.help.common.InvocationResult;
import com.help.common.UnifyPageData;
import com.help.common.UnifyPageInfo;
import com.help.common.annotation.ParamValid;
import com.help.storage.IRoleStorage;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/role"})
@UnifyAuthorization(module="config_role", moduleName="\u89d2\u8272\u7ba1\u7406", system="1")
public class RoleController {
    @Autowired
    private IRoleStorage iRoleStorage;

    @PostMapping(value={"/detail.do"})
    @UnifyAuthorization(op="detail")
    public InvocationResult detail(@ParamValid String roleNo) {
        return new InvocationResult((Object)this.iRoleStorage.get(roleNo));
    }

    @RequestMapping(value={"/list.do"}, method={RequestMethod.POST})
    public InvocationResult list() {
        return new InvocationResult((Object)this.iRoleStorage.list());
    }

    @UnifyAuthorization(op="visit")
    @PostMapping(value={"/listByPage.do"})
    public InvocationResult listByPage(UnifyPageInfo page, @RequestParam(required=false) String name) {
        UnifyPageData list = this.iRoleStorage.searchByPage(name, page);
        return new InvocationResult((Object)list);
    }
}

