/*
 * Decompiled with CFR 0.152.
 */
package com.help.web.controller;

import com.help.ModuleAnalasys;
import com.help.annotation.OperationLog;
import com.help.annotation.UnifyAuthorization;
import com.help.common.InvocationResult;
import com.help.common.annotation.ParamValid;
import com.help.common.util.StringUtil;
import com.help.constant.OperationType;
import com.help.domain.permission.Module;
import com.help.domain.permission.Operation;
import com.help.service.PermissionService;
import com.help.web.module.RoleModuleOp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/permission"})
@UnifyAuthorization(module="config_permission", moduleName="\u6743\u9650\u7ba1\u7406", system="1")
public class PermissionController {
    @Autowired
    ModuleAnalasys moduleAnalasys;
    @Autowired
    PermissionService permissionService;

    @UnifyAuthorization(op="visit")
    @PostMapping(value={"/listAll.do"})
    public InvocationResult<List<Module>> listAll() {
        return new InvocationResult(this.moduleAnalasys.list());
    }

    @UnifyAuthorization(op="visit")
    @PostMapping(value={"/listByModule.do"})
    public InvocationResult<List<Operation>> listByModule(String moduleNo) {
        Module module = this.moduleAnalasys.get(moduleNo);
        if (module != null) {
            return new InvocationResult((Object)module.getOperations());
        }
        return new InvocationResult(new ArrayList());
    }

    @UnifyAuthorization(op="visit")
    @PostMapping(value={"/list.do"})
    public InvocationResult list(@ParamValid String moduleNo, @ParamValid String roleNo) {
        return new InvocationResult(this.permissionService.listPermission(roleNo, moduleNo));
    }

    @UnifyAuthorization(op="grant", opName="\u6388\u6743")
    @PostMapping(value={"/grant.do"})
    @OperationLog(value="\u4e3a\u89d2\u8272[{0}]\u6388\u6743[{1}-{2}]", spel={"#permission.roleNo", "#permission.moduleNo", "#permission.op"}, type=OperationType.SYSTEM)
    public InvocationResult grant(@ParamValid RoleModuleOp permission) {
        this.permissionService.grantPermission(permission);
        return InvocationResult.SUCCESS;
    }

    @UnifyAuthorization(op="grant", opName="\u6388\u6743")
    @PostMapping(value={"/revoke.do"})
    @OperationLog(value="\u64a4\u56de\u89d2\u8272[{0}]\u6743\u9650[{1}-{2}]", spel={"#permission.roleNo", "#permission.moduleNo", "#permission.op"}, type=OperationType.SYSTEM)
    public InvocationResult revoke(@ParamValid RoleModuleOp permission) {
        this.permissionService.revokePermission(permission);
        return InvocationResult.SUCCESS;
    }

    @UnifyAuthorization(op="grant", opName="\u6388\u6743")
    @PostMapping(value={"/save.do"})
    @OperationLog(value="\u4e3a\u89d2\u8272[{0}]\u6279\u91cf\u6388\u6743[{1}]", spel={"#roleNo", "#moduleNo"}, type=OperationType.SYSTEM)
    public InvocationResult save(@ParamValid String roleNo, @ParamValid String moduleNo, String[] ops) {
        if (ops == null) {
            ops = new String[]{};
        }
        ArrayList<String> list = new ArrayList<String>();
        for (String o : ops) {
            if (!StringUtil.isNotEmpty((String)o)) continue;
            list.addAll(Arrays.asList(o.split(",")));
        }
        this.permissionService.reset(roleNo, moduleNo, list.toArray(new String[0]));
        return InvocationResult.SUCCESS;
    }

    @UnifyAuthorization(op="grant", opName="\u6388\u6743")
    @PostMapping(value={"/copy.do"})
    @OperationLog(value="\u590d\u5236\u89d2\u8272[{0}]\u6743\u9650\u5230[{1}]", spel={"#roleFrom", "#roleTo"}, type=OperationType.SYSTEM)
    public InvocationResult copy(@ParamValid String roleFrom, @ParamValid String roleTo) {
        this.permissionService.copy(roleFrom, roleTo);
        return InvocationResult.SUCCESS;
    }
}

