/*
 * Decompiled with CFR 0.152.
 */
package com.help.web.controller;

import com.help.annotation.OperationLog;
import com.help.annotation.UnifyAuthorization;
import com.help.common.ExampleConvert;
import com.help.common.ICacheable;
import com.help.common.IParamReader;
import com.help.common.InvocationResult;
import com.help.common.UnifyPageData;
import com.help.common.UnifyPageInfo;
import com.help.common.annotation.ParamValid;
import com.help.constant.OperationType;
import com.help.constraint.IHelpDomain;
import com.help.domain.PParam;
import com.help.domain.PParamExample;
import com.help.service.manage.PParamService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@UnifyAuthorization(module="config_param", moduleName="\u7cfb\u7edf\u53c2\u6570\u914d\u7f6e", system="1")
@RequestMapping(value={"/pParam"})
public class PParamController {
    private static final Logger logger = LoggerFactory.getLogger(PParamController.class);
    @Autowired
    private PParamService pParamService;
    @Autowired
    IParamReader paramReader;

    @UnifyAuthorization(op="add")
    @PostMapping(value={"/create.do"})
    @OperationLog(value="\u521b\u5efa\u7cfb\u7edf\u53c2\u6570[{0}]", spel={"#pParam.paramKey"}, type=OperationType.SYSTEM)
    public InvocationResult create(@ParamValid PParam pParam) {
        this.pParamService.add(pParam);
        if (this.paramReader instanceof ICacheable) {
            ((ICacheable)this.paramReader).refresh();
        }
        return InvocationResult.SUCCESS;
    }

    @UnifyAuthorization(op="update")
    @PostMapping(value={"/update.do"})
    @OperationLog(value="\u4fee\u6539\u7cfb\u7edf\u53c2\u6570[{0}]", spel={"#pParam.paramKey"}, type=OperationType.SYSTEM)
    public InvocationResult update(@ParamValid PParam pParam) {
        this.pParamService.update(pParam);
        if (this.paramReader instanceof ICacheable) {
            ((ICacheable)this.paramReader).refresh();
        }
        return InvocationResult.SUCCESS;
    }

    @UnifyAuthorization(op="delete")
    @PostMapping(value={"/delete.do"})
    @OperationLog(value="\u5220\u9664\u7cfb\u7edf\u53c2\u6570[{0}]", spel={"#paramKey"}, type=OperationType.SYSTEM)
    public InvocationResult delete(@ParamValid String paramKey) {
        this.pParamService.delete(paramKey);
        if (this.paramReader instanceof ICacheable) {
            ((ICacheable)this.paramReader).refresh();
        }
        return InvocationResult.SUCCESS;
    }

    @UnifyAuthorization(op="detail")
    @PostMapping(value={"/detail.do"})
    public InvocationResult detail(@ParamValid String paramKey) {
        PParam detail = this.pParamService.get(paramKey);
        return new InvocationResult((Object)detail);
    }

    @UnifyAuthorization(op="visit")
    @PostMapping(value={"/listByPage.do"})
    public InvocationResult listByPage(UnifyPageInfo page, PParam pParam) {
        UnifyPageData<PParam> list = this.pParamService.list(page, (PParamExample)ExampleConvert.toLikeExample((IHelpDomain)pParam, PParamExample.class, (String[])new String[0]), new String[0]);
        return new InvocationResult(list);
    }

    @UnifyAuthorization(op="publish", opName="\u63a8\u9001\u53c2\u6570\u53d8\u66f4\u901a\u77e5")
    @PostMapping(value={"/publish.do"})
    public InvocationResult publish() {
        if (this.paramReader instanceof ICacheable) {
            ((ICacheable)this.paramReader).refresh();
        }
        return InvocationResult.SUCCESS;
    }
}

