/*
 * Decompiled with CFR 0.152.
 */
package com.help.web.controller;

import com.help.annotation.UnifyAuthorization;
import com.help.common.InvocationResult;
import com.help.common.annotation.ParamValid;
import com.help.common.util.StringUtil;
import com.help.domain.OrgInfoBase;
import com.help.domain.OrgNode;
import com.help.storage.IOrgStorage;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@UnifyAuthorization(module="config_org", moduleName="\u673a\u6784\u7ba1\u7406", system="1")
@RequestMapping(value={"/org"})
public class OrgController {
    @Autowired
    private IOrgStorage iOrgStorage;

    @PostMapping(value={"/detail.do"})
    @UnifyAuthorization(op="detail")
    public InvocationResult detail(@ParamValid String orgNo) {
        return new InvocationResult((Object)this.iOrgStorage.get(orgNo));
    }

    @PostMapping(value={"/parent.do"})
    public InvocationResult parent(@ParamValid String orgNo) {
        OrgInfoBase base = this.iOrgStorage.get(orgNo);
        if (base == null || StringUtil.isEmpty((String)base.getParentNo())) {
            return new InvocationResult();
        }
        return new InvocationResult((Object)this.iOrgStorage.get(base.getParentNo()));
    }

    @PostMapping(value={"/listChildrens.do"})
    public InvocationResult getChilds(String orgNo) {
        if (StringUtil.isEmpty((String)orgNo)) {
            return new InvocationResult((Object)this.iOrgStorage.listTopWithChilds());
        }
        OrgNode node = this.iOrgStorage.getWithChilds(orgNo, 2);
        if (node != null && node.getChildren() != null) {
            return new InvocationResult((Object)node.getChildren());
        }
        return new InvocationResult(new ArrayList());
    }

    @PostMapping(value={"/list.do"})
    @UnifyAuthorization(op="visit")
    public InvocationResult list() {
        return new InvocationResult((Object)this.iOrgStorage.listTopWithAll());
    }

    @PostMapping(value={"/listByType.do"})
    public InvocationResult listByType(@ParamValid String type, String legal) {
        List list = this.iOrgStorage.listByType(type);
        list = StringUtil.isNotEmpty((String)legal) ? list.stream().filter(p -> legal.equalsIgnoreCase(p.getLegalPersonality())).collect(Collectors.toList()) : list.stream().filter(p -> StringUtil.isEmpty((String)p.getLegalPersonality())).collect(Collectors.toList());
        return new InvocationResult(list);
    }
}

