/*
 * Decompiled with CFR 0.152.
 */
package com.help.web.controller;

import com.help.ITokenContext;
import com.help.LoginInfo;
import com.help.annotation.UnifyAuthorization;
import com.help.common.InvocationResult;
import com.help.common.util.StringUtil;
import com.help.constraint.IHelpOAuthClientProxy;
import com.help.domain.UserInfo;
import com.help.service.PermissionService;
import com.help.storage.IUserStorage;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/oauth"})
public class OAuthController {
    @Autowired(required=false)
    IHelpOAuthClientProxy ioAuthClient;
    @Autowired
    PermissionService permissionService;
    @Autowired
    IUserStorage iUserStorage;
    @Autowired
    ITokenContext<LoginInfo> iTokenContext;

    @ResponseBody
    @PostMapping(value={"/info.do"})
    public InvocationResult<Map> info(String redirectUrl) {
        if (this.ioAuthClient != null) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("loginUrl", this.ioAuthClient.loginUrl(redirectUrl));
            map.put("oauthName", this.ioAuthClient.systemName());
            return new InvocationResult(map);
        }
        return new InvocationResult();
    }

    @ResponseBody
    @UnifyAuthorization
    @PostMapping(value={"/bind-info.do"})
    public InvocationResult bindInfo(String redirectUrl) {
        if (this.ioAuthClient != null) {
            UserInfo user = ((LoginInfo)this.iTokenContext.getCurrentToken()).getCurrentUser();
            HashMap<String, String> result = new HashMap<String, String>();
            result.put("oauthName", this.ioAuthClient.systemName());
            result.put("oauthIndex", this.ioAuthClient.indexUrl());
            result.put("loginUrl", this.ioAuthClient.loginUrl(redirectUrl));
            String oauthUser = this.ioAuthClient.oauthUser(user.getUserNo());
            if (StringUtil.isNotEmpty((String)oauthUser)) {
                result.put("oauthUser", oauthUser);
            } else {
                String bindUrl = this.ioAuthClient.bindUrl(user.getUserNo(), user.getUserName(), redirectUrl);
                result.put("bindUrl", bindUrl);
            }
            return new InvocationResult(result);
        }
        return new InvocationResult();
    }
}

