/*
 * Decompiled with CFR 0.152.
 */
package com.help.web.controller;

import com.help.ITokenContext;
import com.help.LoginInfo;
import com.help.TranscodeBuilder;
import com.help.annotation.UnifyAuthorization;
import com.help.common.InvocationResult;
import com.help.common.exception.UnifyErrorCode;
import com.help.common.exception.UnifyException;
import com.help.common.util.StringUtil;
import com.help.domain.FileInfo;
import com.help.domain.FileInfoBase;
import com.help.service.IFileService;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.InputStreamResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

@Controller
@UnifyAuthorization
@RequestMapping(value={"/file"})
public class FileController {
    Logger logger = LoggerFactory.getLogger(FileController.class);
    @Autowired
    private IFileService iFileService;
    @Autowired
    ITokenContext<LoginInfo> iTokenContext;
    @Autowired
    TranscodeBuilder transcodeBuilder;

    @ResponseBody
    @PostMapping(value={"/upload.do"})
    public InvocationResult<List<String>> upload(@RequestParam(value="file") MultipartFile[] files) {
        String inputer = ((LoginInfo)this.iTokenContext.getCurrentToken()).getUserId();
        ArrayList<String> ids = new ArrayList<String>();
        boolean error = false;
        if (files != null && files.length > 0) {
            for (MultipartFile f : files) {
                String fileName = f.getOriginalFilename();
                if (!StringUtil.isNotEmpty((String)fileName)) continue;
                FileInfoBase file = new FileInfoBase();
                file.setOriginalName(fileName);
                file.setInputUser(inputer);
                file.setFileMime(f.getContentType());
                try {
                    String id = this.iFileService.saveFile(file, f.getInputStream());
                    if (!StringUtil.isNotEmpty((String)id)) continue;
                    ids.add(id);
                }
                catch (Exception e) {
                    error = true;
                    this.logger.info("\u6587\u4ef6{}\u4e0a\u4f20\u5931\u8d25", (Object)fileName, (Object)e);
                    break;
                }
            }
        }
        if (error) {
            for (String id : ids) {
                try {
                    this.iFileService.deleteFile(id);
                }
                catch (Exception e) {
                    this.logger.info("\u6587\u4ef6\u4e0a\u4f20\u53d1\u751f\u9519\u8bef,\u4f46\u8be5\u6279\u6b21\u5df2\u4e0a\u4f20\u6587\u4ef6{}\u56de\u6eda\u5931\u8d25", (Object)id, (Object)e);
                }
            }
            return new InvocationResult(UnifyErrorCode.UNKNOW_FAIL, "\u9644\u4ef6\u4e0a\u4f20\u5931\u8d25,\u8bf7\u67e5\u770b\u7cfb\u7edf\u65e5\u5fd7");
        }
        return new InvocationResult(ids);
    }

    @ResponseBody
    @PostMapping(value={"/info.do"})
    public InvocationResult<FileInfo> info(String fileId) {
        return new InvocationResult((Object)this.iFileService.getInfo(fileId));
    }

    @ResponseBody
    @PostMapping(value={"/infos.do"})
    public InvocationResult<Collection<FileInfo>> infos(String[] fileId) {
        Collection list = this.iFileService.getInfos(fileId).values();
        return new InvocationResult(list);
    }

    @ResponseBody
    @PostMapping(value={"/delete.do"})
    public InvocationResult delete(String fileId) {
        LoginInfo currentUser = (LoginInfo)this.iTokenContext.getCurrentToken();
        FileInfo pFile = this.iFileService.getInfo(fileId);
        if (currentUser.getUserId().equalsIgnoreCase(pFile.getInputUser())) {
            this.iFileService.deleteFile(fileId);
            return InvocationResult.SUCCESS;
        }
        return new InvocationResult(UnifyErrorCode.BUSINESS_FAILD, "\u53ea\u6709\u6587\u4ef6\u4e0a\u4f20\u8005\u80fd\u5220\u9664\u6b64\u6587\u4ef6");
    }

    @UnifyAuthorization(valid=false)
    @GetMapping(value={"/download/{fileId}"})
    public ResponseEntity<?> download(@PathVariable(value="fileId") String fileid, @RequestParam(value="token", required=false) String token) {
        try {
            LoginInfo currentUser = (LoginInfo)this.iTokenContext.getCurrentToken();
            if (currentUser == null) {
                if (StringUtil.isNotEmpty((String)token)) {
                    currentUser = (LoginInfo)this.iTokenContext.getToken(token);
                } else {
                    return new ResponseEntity((Object)new InvocationResult(UnifyErrorCode.RQEUIRED_LOGIN, "\u4e0b\u8f7d\u6587\u4ef6\u5931\u8d25,\u60a8\u5f53\u524d\u5c1a\u672a\u767b\u5f55"), HttpStatus.NOT_FOUND);
                }
            }
            if (currentUser != null) {
                FileInfo pFile = this.iFileService.getInfo(fileid);
                if (pFile != null) {
                    HttpHeaders headers = new HttpHeaders();
                    String nameEncoded = URLEncoder.encode(pFile.getOriginalName(), "UTF-8");
                    headers.set("Content-Disposition", "attachment; filename=\"" + nameEncoded + "\"; filename*=UTF-8''" + nameEncoded);
                    headers.set("Content-Type", pFile.getFileMime());
                    return new ResponseEntity((Object)new InputStreamResource(this.iFileService.getFileStream(fileid)), (MultiValueMap)headers, HttpStatus.OK);
                }
                return new ResponseEntity((Object)new InvocationResult(UnifyErrorCode.NON_DATA, "\u4e0b\u8f7d\u6587\u4ef6\u5931\u8d25,\u6587\u4ef6\u4e0d\u5b58\u5728"), HttpStatus.NOT_FOUND);
            }
            return new ResponseEntity((Object)new InvocationResult(UnifyErrorCode.RQEUIRED_LOGIN, "\u4e0b\u8f7d\u6587\u4ef6\u5931\u8d25,\u60a8\u5f53\u524d\u5c1a\u672a\u767b\u5f55"), HttpStatus.NOT_FOUND);
        }
        catch (UnifyException e) {
            return new ResponseEntity((Object)new InvocationResult(e), HttpStatus.NOT_FOUND);
        }
        catch (Exception e) {
            return new ResponseEntity((Object)new InvocationResult(UnifyErrorCode.NON_DATA, "\u4e0b\u8f7d\u6587\u4ef6\u5931\u8d25"), HttpStatus.NOT_FOUND);
        }
    }
}

