/*
 * Decompiled with CFR 0.152.
 */
package com.help.web.controller;

import com.help.annotation.UnifyAuthorization;
import com.help.common.InvocationResult;
import com.help.common.UnifyPageData;
import com.help.common.UnifyPageInfo;
import com.help.common.annotation.ParamValid;
import com.help.storage.IDeptStorage;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/dept"})
@UnifyAuthorization(module="config_dept", moduleName="\u90e8\u95e8\u7ba1\u7406", system="1")
public class DeptController {
    @Autowired
    private IDeptStorage deptStorage;

    @PostMapping(value={"/detail.do"})
    @UnifyAuthorization(op="detail")
    public InvocationResult detail(@ParamValid String deptNo) {
        return new InvocationResult((Object)this.deptStorage.get(deptNo));
    }

    @RequestMapping(value={"/list.do"}, method={RequestMethod.POST})
    public InvocationResult list() {
        return new InvocationResult((Object)this.deptStorage.list());
    }

    @UnifyAuthorization(op="visit")
    @PostMapping(value={"/listByPage.do"})
    public InvocationResult listByPage(UnifyPageInfo page, @RequestParam(required=false) String name) {
        UnifyPageData list = this.deptStorage.searchByPage(name, page);
        return new InvocationResult((Object)list);
    }
}

