/*
 * Decompiled with CFR 0.152.
 */
package com.help.web.aop;

import com.help.AbstractLoginToken;
import com.help.ITokenContext;
import com.help.LoginInfo;
import com.help.common.util.StringUtil;
import com.help.config.HelpManageConfig;
import com.help.service.ILoginService;
import javax.servlet.http.HttpServletRequest;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.springframework.beans.factory.annotation.Autowired;

@Aspect
public class MockTokenAspect {
    @Autowired
    private ILoginService iLoginService;
    private HelpManageConfig config;
    private ThreadLocal<String> local = new ThreadLocal();
    @Autowired
    HttpServletRequest request;

    public MockTokenAspect(HelpManageConfig config) {
        this.config = config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Around(value="within(com.help.ITokenContext+) && execution(* getCurrentToken(..))")
    public Object exec(ProceedingJoinPoint pjp) throws Throwable {
        Object token = pjp.proceed();
        if (this.local.get() == null) {
            if (token == null && this.config.getMockToken().equals(this.getCurrentTokenKey(this.request))) {
                try {
                    this.local.set("1");
                    LoginInfo loginInfo = null;
                    loginInfo = this.config.getMockUserInfo() != null ? this.config.getMockUserInfo() : this.iLoginService.getToken(this.config.getMockUser());
                    loginInfo.setToken(this.config.getMockToken());
                    ITokenContext iTokenContext = (ITokenContext)pjp.getTarget();
                    iTokenContext.saveToken((AbstractLoginToken)loginInfo);
                    LoginInfo loginInfo2 = loginInfo;
                    return loginInfo2;
                }
                finally {
                    this.local.remove();
                }
            }
            return token;
        }
        return token;
    }

    private String getCurrentTokenKey(HttpServletRequest request) {
        String tokenKey = request.getHeader(this.config.getMockKey());
        if (StringUtil.isEmpty((String)tokenKey)) {
            tokenKey = request.getParameter(this.config.getMockKey());
        }
        return tokenKey;
    }
}

