/*
 * Decompiled with CFR 0.152.
 */
package com.help.web.aop;

import com.help.ITokenContext;
import com.help.LoginInfo;
import com.help.annotation.OperationLog;
import com.help.common.InvocationResult;
import com.help.common.exception.UnifyErrorCode;
import com.help.common.exception.UnifyException;
import com.help.common.util.StringUtil;
import com.help.config.HelpManageConfig;
import com.help.constant.OperationLogStorage;
import com.help.domain.POperationLog;
import com.help.service.POperationLogService;
import com.help.web.aop.GlobalAuthorizationCheckAspect;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.util.Date;
import javax.annotation.PostConstruct;
import javax.servlet.http.HttpServletRequest;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.LocalVariableTableParameterNameDiscoverer;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;

@Aspect
public class HelpOperationLogAspect
implements Ordered {
    private Logger logger = LoggerFactory.getLogger(GlobalAuthorizationCheckAspect.class);
    private ExpressionParser parser = new SpelExpressionParser();
    private LocalVariableTableParameterNameDiscoverer discoverer = new LocalVariableTableParameterNameDiscoverer();
    @Autowired(required=false)
    ITokenContext<LoginInfo> iTokenContext;
    @Autowired
    HelpManageConfig helpManageConfig;
    @Autowired
    HttpServletRequest request;
    @Autowired
    POperationLogService pOperationLogService;
    private boolean logfile;
    private boolean db;

    @PostConstruct
    public void init() {
        OperationLogStorage[] storage = this.helpManageConfig.getOperationLogStorage();
        if (storage != null && storage.length > 0) {
            for (OperationLogStorage s : storage) {
                if (s == OperationLogStorage.DATABASE) {
                    this.db = true;
                    continue;
                }
                if (s != OperationLogStorage.LOGFILE) continue;
                this.logfile = true;
            }
        }
    }

    @Around(value=" @within(org.springframework.stereotype.Controller) && @annotation(com.help.annotation.OperationLog)|| @within(org.springframework.web.bind.annotation.RestController) &&  @annotation(com.help.annotation.OperationLog)")
    public Object execute(ProceedingJoinPoint pjp) throws Throwable {
        if (this.db || this.logfile) {
            Object object;
            block32: {
                Boolean succ = null;
                boolean requireRecord = true;
                try {
                    Object obj = pjp.proceed();
                    if (obj != null && obj instanceof InvocationResult && !UnifyErrorCode.SUCCESS.getCode().equalsIgnoreCase(((InvocationResult)obj).getState())) {
                        succ = false;
                    }
                    object = obj;
                    if (!requireRecord) break block32;
                }
                catch (Exception e) {
                    try {
                        succ = false;
                        if (e instanceof UnifyException && ((UnifyException)((Object)e)).getErrorCode() == UnifyErrorCode.RQEUIRED_LOGIN) {
                            requireRecord = false;
                        }
                        throw e;
                    }
                    catch (Throwable throwable) {
                        if (requireRecord) {
                            Method method = ((MethodSignature)pjp.getSignature()).getMethod();
                            OperationLog operationLog = (OperationLog)AnnotationUtils.findAnnotation((Method)method, OperationLog.class);
                            String str = operationLog.value();
                            String[] params = null;
                            if (operationLog.spel() != null && operationLog.spel().length > 0 || StringUtil.isNotEmpty((String)operationLog.userSpel())) {
                                params = this.discoverer.getParameterNames(method);
                                for (int i = 0; i < operationLog.spel().length; ++i) {
                                    String result = this.parseSpel(pjp.getArgs(), params, operationLog.spel()[i], "");
                                    if (result == null) {
                                        result = "";
                                    }
                                    str = str.replaceAll("\\{" + i + "\\}", result);
                                }
                            }
                            String userId = null;
                            if (StringUtil.isNotEmpty((String)operationLog.userSpel())) {
                                userId = this.parseSpel(pjp.getArgs(), params, operationLog.userSpel(), "");
                            } else if (this.iTokenContext != null) {
                                try {
                                    userId = ((LoginInfo)this.iTokenContext.getCurrentToken()).getUserId();
                                }
                                catch (Exception result) {
                                    // empty catch block
                                }
                            }
                            if (StringUtil.isEmpty(userId)) {
                                userId = "Unknow";
                            }
                            if (succ == null && operationLog.succWhenUnThrow()) {
                                succ = true;
                            }
                            String ip = this.getIpAddr(this.request);
                            if (this.logfile) {
                                this.logger.info("\u7528\u6237[{}({})]  \u6267\u884c [{}]\u64cd\u4f5c {} {}", new Object[]{userId, ip, operationLog.type().getName(), str, succ == null ? "\u7ed3\u679c\u672a\u77e5" : (succ != false ? "\u6210\u529f" : "\u5931\u8d25")});
                            }
                            if (this.db) {
                                POperationLog log = new POperationLog();
                                log.setContent(str);
                                log.setGmtCreate(new Date());
                                log.setIpAddr(ip);
                                log.setOpType(operationLog.type().getCode());
                                log.setSuccess(succ == null ? "" : (succ != false ? "1" : "0"));
                                log.setUserNo(userId);
                                this.pOperationLogService.add(log);
                            }
                        }
                        throw throwable;
                    }
                }
                Method method = ((MethodSignature)pjp.getSignature()).getMethod();
                OperationLog operationLog = (OperationLog)AnnotationUtils.findAnnotation((Method)method, OperationLog.class);
                String str = operationLog.value();
                String[] params = null;
                if (operationLog.spel() != null && operationLog.spel().length > 0 || StringUtil.isNotEmpty((String)operationLog.userSpel())) {
                    params = this.discoverer.getParameterNames(method);
                    for (int i = 0; i < operationLog.spel().length; ++i) {
                        String result = this.parseSpel(pjp.getArgs(), params, operationLog.spel()[i], "");
                        if (result == null) {
                            result = "";
                        }
                        str = str.replaceAll("\\{" + i + "\\}", result);
                    }
                }
                String userId = null;
                if (StringUtil.isNotEmpty((String)operationLog.userSpel())) {
                    userId = this.parseSpel(pjp.getArgs(), params, operationLog.userSpel(), "");
                } else if (this.iTokenContext != null) {
                    try {
                        userId = ((LoginInfo)this.iTokenContext.getCurrentToken()).getUserId();
                    }
                    catch (Exception result) {
                        // empty catch block
                    }
                }
                if (StringUtil.isEmpty(userId)) {
                    userId = "Unknow";
                }
                if (succ == null && operationLog.succWhenUnThrow()) {
                    succ = true;
                }
                String ip = this.getIpAddr(this.request);
                if (this.logfile) {
                    this.logger.info("\u7528\u6237[{}({})]  \u6267\u884c [{}]\u64cd\u4f5c {} {}", new Object[]{userId, ip, operationLog.type().getName(), str, succ == null ? "\u7ed3\u679c\u672a\u77e5" : (succ != false ? "\u6210\u529f" : "\u5931\u8d25")});
                }
                if (this.db) {
                    POperationLog log = new POperationLog();
                    log.setContent(str);
                    log.setGmtCreate(new Date());
                    log.setIpAddr(ip);
                    log.setOpType(operationLog.type().getCode());
                    log.setSuccess(succ == null ? "" : (succ != false ? "1" : "0"));
                    log.setUserNo(userId);
                    this.pOperationLogService.add(log);
                }
            }
            return object;
        }
        return pjp.proceed();
    }

    private String parseSpel(Object[] arguments, String[] argumentNames, String spel, String defaultResult) {
        StandardEvaluationContext context = new StandardEvaluationContext();
        for (int len = 0; len < argumentNames.length; ++len) {
            context.setVariable(argumentNames[len], arguments[len]);
        }
        try {
            Expression expression = this.parser.parseExpression(spel);
            return (String)expression.getValue((EvaluationContext)context, String.class);
        }
        catch (Exception e) {
            return defaultResult;
        }
    }

    private String getIpAddr(HttpServletRequest request) {
        String ip = request.getHeader("x-forwarded-for");
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if ((ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) && (ip = request.getRemoteAddr()).equals("127.0.0.1")) {
            InetAddress inet = null;
            try {
                inet = InetAddress.getLocalHost();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ip = inet.getHostAddress();
        }
        if (ip != null && ip.length() > 15 && ip.indexOf(",") > 0) {
            ip = ip.substring(0, ip.indexOf(","));
        }
        return ip;
    }

    public int getOrder() {
        return 15;
    }
}

