/*
 * Decompiled with CFR 0.152.
 */
package com.help.web.aop;

import com.help.ITokenContext;
import com.help.LoginInfo;
import com.help.common.util.StringUtil;
import com.help.config.HelpManageConfig;
import com.help.storage.legal.ILegalableStorage;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.beans.factory.annotation.Autowired;

@Aspect
public class HelpLegalableStorageAutoSwitchAspect {
    @Autowired
    ITokenContext<LoginInfo> iTokenContext;
    @Autowired
    HelpManageConfig helpManageConfig;

    @Around(value="within(com.help.storage.legal.ILegalableStorage+) && execution(public * *(..)) && !execution(public * getLegalProxy(String)) && !execution(public * getEditableLegalProxy(String)))")
    public Object edit(ProceedingJoinPoint joinPoint) throws Throwable {
        LoginInfo loginInfo;
        if (this.helpManageConfig.isMultiLegalEnable() && this.iTokenContext != null && (loginInfo = (LoginInfo)this.iTokenContext.getCurrentToken()) != null && loginInfo.getLoginRoles() != null && !loginInfo.getLoginRoles().contains("admin") && StringUtil.isNotEmpty((String)loginInfo.getLegalPersonality())) {
            String legal = loginInfo.getLegalPersonality();
            Object target = ((ILegalableStorage)joinPoint.getTarget()).getLegalProxy(legal);
            Method method = ((MethodSignature)joinPoint.getSignature()).getMethod();
            try {
                Method mtd = target.getClass().getMethod(method.getName(), method.getParameterTypes());
                return mtd.invoke(target, joinPoint.getArgs());
            }
            catch (InvocationTargetException e) {
                throw e.getTargetException();
            }
        }
        return joinPoint.proceed();
    }
}

