/*
 * Decompiled with CFR 0.152.
 */
package com.help.web.aop;

import com.help.ITokenContext;
import com.help.LoginInfo;
import com.help.annotation.UnifyAuthorization;
import com.help.common.exception.UnifyErrorCode;
import com.help.common.exception.UnifyException;
import com.help.common.util.StringUtil;
import com.help.config.HelpManageConfig;
import com.help.service.IPermissionService;
import java.lang.reflect.Method;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.Ordered;

@Aspect
public class GlobalAuthorizationCheckAspect
implements Ordered {
    private Logger logger = LoggerFactory.getLogger(GlobalAuthorizationCheckAspect.class);
    @Autowired
    ITokenContext<LoginInfo> iTokenContext;
    @Autowired
    private IPermissionService iPermissionService;
    @Autowired
    HelpManageConfig helpManageConfig;

    @Before(value="@within(com.help.annotation.UnifyAuthorization) && @within(org.springframework.stereotype.Controller)|| @within(com.help.annotation.UnifyAuthorization) && @within(org.springframework.web.bind.annotation.RestController)|| @annotation(com.help.annotation.UnifyAuthorization)")
    public void execute(JoinPoint pjp) {
        String target = pjp.getSignature().getDeclaringTypeName();
        Method method = ((MethodSignature)pjp.getSignature()).getMethod();
        UnifyAuthorization anno = method.getAnnotation(UnifyAuthorization.class);
        UnifyAuthorization classAnno = pjp.getSignature().getDeclaringType().getAnnotation(UnifyAuthorization.class);
        if (anno != null && anno.valid() || anno == null && classAnno != null && classAnno.valid()) {
            String module = null;
            String op = null;
            String system = null;
            String moduleName = null;
            String opName = null;
            boolean grantToAll = false;
            if (anno != null) {
                module = anno.module();
                moduleName = anno.moduleName();
                op = anno.op();
                opName = anno.opName();
                system = anno.system();
                grantToAll = anno.grantToAll();
            }
            if (classAnno != null) {
                if (StringUtil.isEmpty((String)module)) {
                    module = classAnno.module();
                    moduleName = classAnno.moduleName();
                }
                if (StringUtil.isEmpty(op)) {
                    op = classAnno.op();
                    opName = classAnno.opName();
                }
                if (StringUtil.isEmpty(system)) {
                    system = classAnno.system();
                }
                if (anno == null) {
                    grantToAll = classAnno.grantToAll();
                }
            }
            this.logger.debug("\u6b63\u5728\u9a8c\u8bc1[" + target + "]\u7684[" + method.getName() + "]\u8c03\u7528\u6743\u9650,\u6240\u5c5e\u6a21\u5757:[" + StringUtil.nvl((String)moduleName, (String)"") + module + "],\u529f\u80fd:[" + StringUtil.nvl((String)opName, (String)"") + op + "]");
            LoginInfo current = (LoginInfo)this.iTokenContext.getCurrentToken();
            if (current == null) {
                throw new UnifyException(UnifyErrorCode.RQEUIRED_LOGIN);
            }
            if (!this.helpManageConfig.isDisablePermission()) {
                if (grantToAll) {
                    this.logger.debug("\u6240\u6709\u7528\u6237\u9ed8\u8ba4\u62e5\u6709\u8be5\u6743\u9650,\u8df3\u8fc7\u9a8c\u8bc1");
                } else if (current.getLoginRoles() != null && current.getLoginRoles().stream().anyMatch(p -> p.equalsIgnoreCase("admin")) && "1".equalsIgnoreCase(system)) {
                    this.logger.debug("\u7cfb\u7edf\u7ba1\u7406\u5458\u9ed8\u8ba4\u62e5\u6709\u8be5\u6743\u9650,\u8df3\u8fc7\u9a8c\u8bc1");
                } else if (StringUtil.isNotEmptyAll((String[])new String[]{module, op}) && !this.iPermissionService.check(current, module, op)) {
                    throw new UnifyException(UnifyErrorCode.UN_AUTHORIZATION);
                }
            }
        }
    }

    public int getOrder() {
        return 100;
    }
}

