/*
 * Decompiled with CFR 0.152.
 */
package com.help.validator;

import com.help.annotation.InDic;
import com.help.common.exception.UnifyValidateException;
import com.help.common.util.Convert;
import com.help.common.validate.intf.IFieldValidator;
import com.help.domain.DicItem;
import com.help.domain.TreeDicItem;
import com.help.service.DictionaryService;
import com.help.validator.HelpValidator;
import java.lang.reflect.Field;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;

public class InDicFieldValidator
implements IFieldValidator<InDic, Object> {
    @Autowired
    DictionaryService dictionaryService;

    public void validate(Field field, Object value, Object o, InDic anno) {
        List arr = null;
        List<DicItem> items = this.dictionaryService.list(anno.value());
        if (items != null && items.size() > 0) {
            arr = items.stream().map(p -> p.getCode()).collect(Collectors.toList());
        } else {
            List<TreeDicItem> dics = this.dictionaryService.listTree(anno.value());
            if (dics != null && dics.size() > 0) {
                arr = dics.stream().map(p -> p.getCode()).collect(Collectors.toList());
            }
        }
        if (arr != null && arr.size() > 0) {
            if (value instanceof Number) {
                value = Convert.toString((Object)value);
            }
            if (value instanceof String) {
                boolean contain = false;
                for (String s : arr) {
                    if (!((String)value).equalsIgnoreCase(s)) continue;
                    contain = true;
                    break;
                }
                if (!contain) {
                    throw new UnifyValidateException(HelpValidator.getFieldName((Field)field) + "\u7684\u53d6\u503c\u4e0d\u5728\u5b57\u5178[" + anno.value() + "]\u5141\u8bb8\u7684\u8303\u56f4\u5185");
                }
            }
        }
    }
}

