/*
 * Decompiled with CFR 0.152.
 */
package com.help.service.manage;

import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.help.common.UnifyPageData;
import com.help.common.UnifyPageInfo;
import com.help.common.exception.UnifyErrorCode;
import com.help.common.exception.UnifyException;
import com.help.constraint.ISearchable;
import com.help.dao.PParamMapper;
import com.help.dao.batch.BatchExecuter;
import com.help.dao.batch.BatchHelper;
import com.help.dao.batch.IExecuteSingleAction;
import com.help.domain.PParam;
import com.help.domain.PParamExample;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PParamService
implements ISearchable<PParam, PParamExample> {
    @Autowired
    private PParamMapper mapper;
    @Autowired
    private BatchHelper batchHelper;

    public PParam add(PParam entity) {
        this.mapper.insert(entity);
        return entity;
    }

    @Transactional
    public void addBatch(List<PParam> list) {
        BatchExecuter executer = this.batchHelper.getBatchExecuter(PParamMapper.class);
        executer.execute(list, (IExecuteSingleAction)new IExecuteSingleAction<PParamMapper, PParam>(){

            public void execute(PParamMapper dao, PParam entity) {
                dao.insert(entity);
            }
        });
    }

    public void update(PParam entity) {
        if (this.mapper.updateByPrimaryKey(entity) == 0) {
            throw new UnifyException(UnifyErrorCode.NON_DATA);
        }
    }

    public void updateSelective(PParam entity) {
        if (this.mapper.updateByPrimaryKeySelective(entity) == 0) {
            throw new UnifyException(UnifyErrorCode.NON_DATA);
        }
    }

    public void delete(String key) {
        if (this.mapper.deleteByPrimaryKey(key) == 0) {
            throw new UnifyException(UnifyErrorCode.NON_DATA);
        }
    }

    public PParam get(String key) {
        return this.mapper.selectByPrimaryKey(key);
    }

    public List<PParam> list() {
        return this.mapper.selectByExample(null);
    }

    public List<PParam> list(PParamExample example, String ... columns) {
        if (columns == null || columns.length == 0) {
            return this.mapper.selectByExample(example);
        }
        return this.mapper.selectColumnsByExample(example, columns);
    }

    public UnifyPageData<PParam> list(UnifyPageInfo pageInfo) {
        PageHelper.startPage((int)pageInfo.getPageIndex(), (int)pageInfo.getPageSize());
        List list = this.mapper.selectByExample(null);
        PageInfo info = new PageInfo(list);
        pageInfo.setTotalCount(info.getTotal());
        return new UnifyPageData((Collection)info.getList(), pageInfo);
    }

    public UnifyPageData<PParam> list(UnifyPageInfo pageInfo, PParamExample example, String ... columns) {
        PageHelper.startPage((int)pageInfo.getPageIndex(), (int)pageInfo.getPageSize());
        List list = null;
        list = columns == null || columns.length == 0 ? this.mapper.selectByExample(example) : this.mapper.selectColumnsByExample(example, columns);
        PageInfo info = new PageInfo(list);
        pageInfo.setTotalCount(info.getTotal());
        return new UnifyPageData((Collection)info.getList(), pageInfo);
    }
}

