/*
 * Decompiled with CFR 0.152.
 */
package com.help.service;

import java.util.UUID;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.cache.annotation.Caching;
import org.springframework.stereotype.Component;
import org.springframework.stereotype.Service;

@Service
public class ValidCodeService {
    @Autowired
    CacheValidCodeStorage cacheValidCodeStorage;

    public String createKey(String validCode) {
        String key = UUID.randomUUID().toString().replaceAll("-", "");
        return this.createKey(validCode, key);
    }

    public String createKey(String validCode, String key) {
        this.cacheValidCodeStorage.save(key, validCode);
        return key;
    }

    public boolean valid(String key, String validCode) {
        String code = this.cacheValidCodeStorage.getAndClean(key);
        return code != null && code.equalsIgnoreCase(validCode);
    }

    public void removeKey(String key) {
        this.cacheValidCodeStorage.clean(key);
    }

    @Component
    public static class CacheValidCodeStorage {
        @Caching(cacheable={@Cacheable(value={"short"}, key="'VALID-CODE-'+#key")}, evict={@CacheEvict(value={"short"}, key="'VALID-CODE-'+#key")})
        public String getAndClean(String key) {
            return null;
        }

        @Cacheable(value={"short"}, key="'VALID-CODE-'+#key")
        public String save(String key, String validCode) {
            return validCode;
        }

        @CacheEvict(value={"short"}, key="'VALID-CODE-'+#key")
        public void clean(String key) {
        }
    }
}

